package com.bxm.lovelink.common.push.factory.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.lovelink.common.dal.entity.PushTask;
import com.bxm.lovelink.common.dal.entity.User;
import com.bxm.lovelink.common.dal.service.IPushTaskService;
import com.bxm.lovelink.common.dal.service.IUserService;
import com.bxm.lovelink.common.push.factory.AbstractTimerPushSceneService;
import com.bxm.lovelink.common.push.factory.PushScene;
import com.bxm.lovelink.common.push.factory.PushTarget;
import com.bxm.warcar.cache.Fetcher;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 *  资料填写中断
 * @author dll
 * @date 2025/6/17
 */
@Component
public class DataInterruptTimerPushSceneService extends AbstractTimerPushSceneService {

    private final IUserService userService;

    public DataInterruptTimerPushSceneService(IPushTaskService pushTaskService,
                                              Fetcher fetcher, IUserService userService) {
        super(pushTaskService, fetcher);
        this.userService = userService;
    }

    @Override
    protected List<PushTarget> findPushTaskTargets(PushTask pushTask) {
        //用户进入注册页面后，在3小时后未完成100%资料填写，发送推送事件
        //定时查询(10分钟一次)根据用户，创建时间 +3小时 ，并且register_finish_time为空 ，
        // 查找所有符合条件的用户，每个用户先判断近一周有没有发送过推送事件，
        // 没注册完成的,并且一周内没发送过推送事件的，则发送推送监听事件(PushEvent),并且保存redis
        LambdaQueryWrapper<User> lambdaQueryWrapper = new LambdaQueryWrapper<User>();
        lambdaQueryWrapper.isNull(User::getRegisterFinishTime);
        lambdaQueryWrapper.isNotNull(User::getPushClientid);
        lambdaQueryWrapper.apply("DATE_ADD(create_time, INTERVAL 3 HOUR) <= NOW()");
        lambdaQueryWrapper.apply("DATE_ADD(create_time, INTERVAL " + pushTask.getTaskEndOfLife() + " DAY) >= NOW()");
        List<User> userList = userService.list(lambdaQueryWrapper);
        return userList.stream().map(new Function<User, PushTarget>() {
            @Override
            public PushTarget apply(User user) {
                return new PushTarget()
                        .setUserId(user.getId());
            }
        }).collect(Collectors.toList());
    }

    @Override
    public PushScene of() {
        return PushScene.DATA_INTERRUPT;
    }
}
