package com.bxm.lovelink.common.push.factory.impl;


import com.bxm.lovelink.common.dal.entity.PushTask;
import com.bxm.lovelink.common.dal.service.IPushTaskService;
import com.bxm.lovelink.common.push.factory.AbstractImmediatePushSceneService;
import com.bxm.lovelink.common.push.factory.PushScene;
import com.bxm.lovelink.common.push.factory.PushTarget;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * 完成实名认证
 * @author: weixing
 */
@Component
public class FinishRealNameGuideTimerPushSceneService extends AbstractImmediatePushSceneService {

    protected FinishRealNameGuideTimerPushSceneService(IPushTaskService pushTaskService) {
        super(pushTaskService);
    }
    @Override
    public Map<String, Object> createTemplateParameters(PushTask pushTask, PushTarget pushTarget) {
        pushTarget.setPayload(Collections.singletonMap("type", of().name()));
        Boolean forceNotification = (Boolean) pushTarget.getExtend().get("force_notification");
        return new HashMap<String, Object>() {{
            put("force_notification", forceNotification);
        }};
    }

    @Override
    public PushScene of() {
        return PushScene.FINISH_REAL_NAME;
    }
}
