package com.bxm.lovelink.common.push.factory.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.MeetGroup;
import com.bxm.lovelink.common.dal.entity.PushTask;
import com.bxm.lovelink.common.dal.service.IMeetGroupService;
import com.bxm.lovelink.common.dal.service.IPushTaskService;
import com.bxm.lovelink.common.push.factory.AbstractTimerPushSceneService;
import com.bxm.lovelink.common.push.factory.PushScene;
import com.bxm.lovelink.common.push.factory.PushTarget;
import com.bxm.warcar.cache.Fetcher;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author Allen Hu
 * @date 2025/6/17
 */
@Component
public class MeetGroupExpireTimerPushSceneService extends AbstractTimerPushSceneService {

    private final IMeetGroupService meetGroupService;

    public MeetGroupExpireTimerPushSceneService(IPushTaskService pushTaskService, Fetcher fetcher, IMeetGroupService meetGroupService) {
        super(pushTaskService, fetcher);
        this.meetGroupService = meetGroupService;
    }

    @Override
    protected List<PushTarget> findPushTaskTargets(PushTask pushTask) {
        String taskSceneCustomConfig = pushTask.getTaskSceneCustomConfig();
        int hours = NumberUtils.toInt(taskSceneCustomConfig);
        if (hours <= 0) {
            return null;
        }
        // 查找离过期时间不足 hours 的群组
        LambdaQueryWrapper<MeetGroup> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(MeetGroup::getGroupStatus, Constants.MeetGroupConst.GroupStatus.WAIT_ACCEPT.value());
        lambdaQueryWrapper.apply("DATE_SUB(invite_expire_time, INTERVAL " + hours + " HOUR) <= NOW()");
        List<MeetGroup> meetGroupList = meetGroupService.list(lambdaQueryWrapper);
        return meetGroupList.stream().map(new Function<MeetGroup, PushTarget>() {
            @Override
            public PushTarget apply(MeetGroup meetGroup) {
                return new PushTarget()
                        .setUserId(meetGroup.getAcceptUserId())
                        .addExtend("meetGroup", meetGroup);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public Map<String, Object> createTemplateParameters(PushTask pushTask, PushTarget pushTarget) {
        MeetGroup meetGroup = (MeetGroup) pushTarget.getExtend().get("meetGroup");
        // 温馨提示：你收到的约见邀请群 <meetGroupId> 即将在不足 <hour> 小时后失效，不要错过哦！
        return new HashMap<String, Object>() {{
            put("hour", pushTask.getTaskSceneCustomConfig());
            //put("meetGroupId", meetGroup.getId());
        }};
    }

    @Override
    public PushScene of() {
        return PushScene.EXPIRE_MEET_REQUEST;
    }
}
