package com.bxm.lovelink.common.push.factory.impl;

import com.bxm.lovelink.common.dal.entity.PushTask;
import com.bxm.lovelink.common.dal.service.IPushTaskService;
import com.bxm.lovelink.common.push.factory.AbstractImmediatePushSceneService;
import com.bxm.lovelink.common.push.factory.PushScene;
import com.bxm.lovelink.common.push.factory.PushTarget;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * 收到约见邀请
 *
 * @author dll
 * @date 2025/6/17
 */
@Component
public class MeetRequestTimerPushSceneService extends AbstractImmediatePushSceneService {

    public MeetRequestTimerPushSceneService(IPushTaskService pushTaskService) {
        super(pushTaskService);
    }

    @Override
    public Map<String, Object> createTemplateParameters(PushTask pushTask, PushTarget pushTarget) {
        //你有一个约会邀请待查收，<nickName> 正期待你的回应！
        String nickName = (String) pushTarget.getExtend().get("nickName");
        return new HashMap<String, Object>() {{
            put("nickName", nickName);
        }};
    }

    @Override
    public PushScene of() {
        return PushScene.MEET_REQUEST;
    }
}
