package com.bxm.lovelink.common.push.factory.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.MeetGroup;
import com.bxm.lovelink.common.dal.entity.PushTask;
import com.bxm.lovelink.common.dal.entity.dao.MeetGroupDao;
import com.bxm.lovelink.common.dal.service.IMeetGroupService;
import com.bxm.lovelink.common.dal.service.IPushTaskService;
import com.bxm.lovelink.common.push.factory.AbstractTimerPushSceneService;
import com.bxm.lovelink.common.push.factory.PushScene;
import com.bxm.lovelink.common.push.factory.PushTarget;
import com.bxm.warcar.cache.Fetcher;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.*;

/**
 * @author Allen Hu
 * @date 2025/6/27
 */
@Slf4j
@Service
public class MeetTimeoutFeedbackPushSceneService extends AbstractTimerPushSceneService {

    private final IMeetGroupService meetGroupService;

    public MeetTimeoutFeedbackPushSceneService(IPushTaskService pushTaskService, Fetcher fetcher, IMeetGroupService meetGroupService) {
        super(pushTaskService, fetcher);
        this.meetGroupService = meetGroupService;
    }

    @Override
    public PushScene of() {
        return PushScene.MEET_TIMEOUT_FEEDBACK;
    }

    @Override
    protected List<PushTarget> findPushTaskTargets(PushTask pushTask) {
        List<PushTarget> pushTargets = Lists.newArrayList();
        try {
            QueryWrapper<MeetGroup> queryWrapper = new QueryWrapper<MeetGroup>()
                    .eq(MeetGroup.GROUP_STATUS, Constants.MeetGroupConst.GroupStatus.ACCEPT.value())
                    .eq(MeetGroup.MEET_STATUS, Constants.MeetGroupConst.MeetAddressStatus.CONFIRM.value())
                    .lt(MeetGroup.MEET_TIME_START, LocalDateTime.now().minusHours(48))
                    .lt(MeetGroup.PUSH_COUNT, 1);

            List<MeetGroupDao> timeoutList = meetGroupService.listDao(queryWrapper);
            for (MeetGroupDao meetGroup : timeoutList) {
                try {
                    Integer meetInviteUserResult = meetGroup.getMeetInviteUserResult();
                    Integer meetAcceptUserResult = meetGroup.getMeetAcceptUserResult();
                    if (Objects.isNull(meetInviteUserResult)) {
                        // 给邀请方发送消息
                        HashMap<String, Object> map = Maps.newHashMap();
                        map.put("nickName", meetGroup.getAcceptUserBasicInfo().getNickname());
                        PushTarget pushTarget = new PushTarget()
                                .setUserId(meetGroup.getInviteUserId())
                                .setExtend(map);

                        pushTargets.add(pushTarget);
                    }
                    if (Objects.isNull(meetAcceptUserResult)) {
                        // 给被邀请方发送消息
                        HashMap<String, Object> map = Maps.newHashMap();
                        map.put("nickName", meetGroup.getInviteUserBasicInfo().getNickname());
                        PushTarget pushTarget = new PushTarget()
                                .setUserId(meetGroup.getAcceptUserId())
                                .setExtend(map);

                        pushTargets.add(pushTarget);
                    }
                    meetGroup.setPushCount(Optional.ofNullable(meetGroup.getPushCount()).orElse(0) + 1);
                    meetGroupService.updateById(meetGroup);
                } catch (Exception e) {
                    log.error("handleMeetResultTimeout: {}", meetGroup, e);
                }
            }
        } catch (Exception e) {
            log.error("schedule:", e);
        }
        return pushTargets;
    }

    @Override
    public Map<String, Object> createTemplateParameters(PushTask pushTask, PushTarget pushTarget) {
        // 和[对方昵称]的见面顺利吗？来反馈一下体验吧
        String nickName = (String) pushTarget.getExtend().get("nickName");
        return new HashMap<String, Object>() {{
            put("nickName", nickName);
        }};
    }
}
