package com.bxm.lovelink.common.push.factory.impl;

import com.bxm.lovelink.common.dal.entity.PushTask;
import com.bxm.lovelink.common.dal.service.IPushTaskService;
import com.bxm.lovelink.common.push.factory.AbstractImmediatePushSceneService;
import com.bxm.lovelink.common.push.factory.PushScene;
import com.bxm.lovelink.common.push.factory.PushTarget;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * 双向心动
 *
 * @author weixing
 * @date 2025/6/17
 */
@Component
public class MutualLoveTimerPushSceneService extends AbstractImmediatePushSceneService {

    public MutualLoveTimerPushSceneService(IPushTaskService pushTaskService) {
        super(pushTaskService);
    }

    @Override
    public Map<String, Object> createTemplateParameters(PushTask pushTask, PushTarget pushTarget) {
        //“您有来自 <nickName> 的新消息 ”
        String nickName = (String) pushTarget.getExtend().get("nickName");
        return new HashMap<String, Object>() {{
            put("nickName", nickName);
        }};
    }

    @Override
    public PushScene of() {
        return PushScene.MUTUAL_LOVE;
    }
}
