package com.bxm.lovelink.common.push.factory.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.lovelink.common.dal.entity.PushTask;
import com.bxm.lovelink.common.dal.entity.UserLoveCondition;
import com.bxm.lovelink.common.dal.service.IPushTaskService;
import com.bxm.lovelink.common.dal.service.IUserLoveConditionService;
import com.bxm.lovelink.common.dal.service.IUserService;
import com.bxm.lovelink.common.push.factory.AbstractTimerPushSceneService;
import com.bxm.lovelink.common.push.factory.PushScene;
import com.bxm.lovelink.common.push.factory.PushTarget;
import com.bxm.warcar.cache.Fetcher;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 理想伴侣信息未填写
 *
 * @author dll
 * @date 2025/06/18 15:17
 */
@Component
public class NoLoveCondtionTimerPushSceneService extends AbstractTimerPushSceneService {


    private final IUserService userService;

    private final IUserLoveConditionService userLoveConditionService;

    public NoLoveCondtionTimerPushSceneService(IPushTaskService pushTaskService,
                                               Fetcher fetcher, IUserService userService,
                                               IUserLoveConditionService userLoveConditionService) {
        super(pushTaskService, fetcher);
        this.userService = userService;
        this.userLoveConditionService = userLoveConditionService;
    }

    @Override
    protected List<PushTarget> findPushTaskTargets(PushTask pushTask) {
        //定时（10分钟）user_love_condition 这个表的 info_complete_progress 这个小于100，
        // 的然后判断近一周有没有推送过数据   过期时间一周
        LambdaQueryWrapper<UserLoveCondition> lambdaQueryWrapper = new LambdaQueryWrapper<UserLoveCondition>();
        lambdaQueryWrapper.lt(UserLoveCondition::getInfoCompleteProgress, 100);
        lambdaQueryWrapper.apply("DATE_ADD(create_time, INTERVAL " + pushTask.getTaskEndOfLife() + " DAY) >= NOW()");
        List<UserLoveCondition> userLoveConditionList = userLoveConditionService.list(lambdaQueryWrapper);
        return userLoveConditionList.stream().map(new Function<UserLoveCondition, PushTarget>() {
            @Override
            public PushTarget apply(UserLoveCondition userLoveCondition) {
                return new PushTarget()
                        .setUserId(userLoveCondition.getUserId());
            }
        }).collect(Collectors.toList());
    }


    @Override
    public PushScene of() {
        return PushScene.NO_LOVE_CONDTION;
    }
}
