package com.bxm.lovelink.common.push.factory.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.lovelink.common.dal.entity.PushTask;
import com.bxm.lovelink.common.dal.entity.User;
import com.bxm.lovelink.common.dal.service.IPushTaskService;
import com.bxm.lovelink.common.dal.service.IUserService;
import com.bxm.lovelink.common.push.factory.AbstractTimerPushSceneService;
import com.bxm.lovelink.common.push.factory.PushScene;
import com.bxm.lovelink.common.push.factory.PushTarget;
import com.bxm.warcar.cache.Fetcher;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 首次注册后24H内初期未使用
 * @author dll
 * @date 2025/6/18
 */
@Component
public class RegisterSuccessNotUseTimerPushSceneService extends AbstractTimerPushSceneService {


    private final IUserService userService;

    public RegisterSuccessNotUseTimerPushSceneService(IPushTaskService pushTaskService,
                                                      Fetcher fetcher, IUserService userService) {
        super(pushTaskService, fetcher);
        this.userService = userService;
    }

    @Override
    protected List<PushTarget> findPushTaskTargets(PushTask pushTask) {
        //定时查询(10分钟一次),用户触发注册完成后,根据register_finish_time这个字段（不为空代表注册完成），
        // 查找所有注册完成的用户，在注册完成的时间超过24 ，没有曝光的用户
        LambdaQueryWrapper<User> lambdaQueryWrapper = new LambdaQueryWrapper<User>();
        lambdaQueryWrapper.isNotNull(User::getRegisterFinishTime);
        lambdaQueryWrapper.isNotNull(User::getPushClientid);
        lambdaQueryWrapper.apply("DATE_ADD(register_finish_time, INTERVAL 24 HOUR) <= NOW()");
        lambdaQueryWrapper.apply("DATE_ADD(last_on_line_time, INTERVAL 24 HOUR) < NOW()");
        lambdaQueryWrapper.apply("DATE_ADD(create_time, INTERVAL " + pushTask.getTaskEndOfLife() + " DAY) >= NOW()");
        List<User> userList = userService.list(lambdaQueryWrapper);
        return userList.stream().map(new Function<User, PushTarget>() {
            @Override
            public PushTarget apply(User user) {
                return new PushTarget()
                        .setUserId(user.getId());
            }
        }).collect(Collectors.toList());
    }

    @Override
    public PushScene of() {
        return PushScene.REGISTER_SUCCESS_24H_NOT_USE;
    }
}
