package com.bxm.lovelink.common.push.factory.impl;

import com.bxm.lovelink.common.dal.entity.PushTask;
import com.bxm.lovelink.common.dal.service.IPushTaskService;
import com.bxm.lovelink.common.push.factory.AbstractImmediatePushSceneService;
import com.bxm.lovelink.common.push.factory.PushScene;
import com.bxm.lovelink.common.push.factory.PushTarget;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * 见面邀约被拒绝
 *
 * @author dll
 * @date 2025/6/17
 */
@Component
public class RejectedMeetRequestTimerPushSceneService extends AbstractImmediatePushSceneService {

    public RejectedMeetRequestTimerPushSceneService(IPushTaskService pushTaskService) {
        super(pushTaskService);
    }

    @Override
    public Map<String, Object> createTemplateParameters(PushTask pushTask, PushTarget pushTarget) {
        //<nickName>  已拒绝了您的见面邀请。
        String nickName = (String) pushTarget.getExtend().get("nickName");
        return new HashMap<String, Object>() {{
            put("nickName", nickName);
        }};
    }

    @Override
    public PushScene of() {
        return PushScene.REJECTED_MEET_REQUEST;
    }
}
