package com.bxm.lovelink.common.push.listenter.push;

import com.bxm.lovelink.common.integration.uni.push.UniPushIntegration;
import com.bxm.lovelink.common.integration.uni.push.UniappPushMsgRequest;
import com.bxm.lovelink.common.push.Pusher;
import com.bxm.lovelink.common.push.event.push.PushEvent;
import com.bxm.lovelink.common.push.factory.Push;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.springframework.stereotype.Component;

/**
 * @author Allen Hu
 * @date 2025/6/17
 */
@Component
public class UniappPushEventListener implements EventListener<PushEvent> {

    private final Pusher pusher;
    private final UniPushIntegration uniapIntegration;

    public UniappPushEventListener(Pusher pusher, UniPushIntegration uniapIntegration) {
        this.pusher = pusher;
        this.uniapIntegration = uniapIntegration;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(PushEvent event) {
        Push push = event.getPush();
        UniappPushMsgRequest uniappPushMsgRequest = pusher.buildUniappPushMsgRequest(push);
        if (uniappPushMsgRequest == null) {
            return;
        }
        uniapIntegration.push(uniappPushMsgRequest);
    }
}
