package com.bxm.lovelink.common.push.render;

import com.bxm.lovelink.common.dal.entity.PushTask;
import com.bxm.lovelink.common.push.factory.PushScene;
import com.bxm.lovelink.common.push.factory.PushTarget;
import com.google.common.collect.Maps;
import org.stringtemplate.v4.ST;

import java.util.Map;

/**
 * 推送内容渲染器
 *
 * @author Allen Hu
 * @since 2025-06-18
 */
public interface PushRender {

    PushRender SIMPLE = () -> null;

    /**
     * 定义这个实现属于哪个推送场景
     * @return 推送场景
     */
    PushScene of();

    /**
     * 创建推送消息内容的模板变量
     * @param pushTask 推送任务
     * @param pushTarget 推送目标
     * @return 模板变量
     */
    default Map<String, Object> createTemplateParameters(PushTask pushTask, PushTarget pushTarget) {
        return Maps.newHashMap();
    }

    default String renderPushMessage(PushTask pushTask, PushTarget pushTarget) {
        String pushMessage = pushTask.getPushMessage();
        return render(pushTask, pushTarget, pushMessage);
    }

    default String renderPushPayload(PushTask pushTask, PushTarget pushTarget) {
        String pushPayload = pushTask.getPushPayload();
        return render(pushTask, pushTarget, pushPayload);
    }

    default String render(PushTask pushTask, PushTarget pushTarget, String pushMessage) {
        ST template = new ST(pushMessage);
        Map<String, Object> templateContext = createTemplateParameters(pushTask, pushTarget);
        for (Map.Entry<String, Object> entry : templateContext.entrySet()) {
            template.add(entry.getKey(), entry.getValue());
        }
        return template.render();
    }

}
