package com.bxm.lovelink.common.push.scheduler;

import com.bxm.lovelink.common.push.Pusher;
import com.bxm.lovelink.common.push.factory.PushScene;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * @author dll
 * @date 2025/6/14
 */
@Component
public class PushTaskScheduler {
    private final Pusher pusher;

    public PushTaskScheduler( Pusher pusher) {
        this.pusher = pusher;
    }

    //@Scheduled(cron = "0 */10 * * * ?")
    public void dataInterrupt() {
        pusher.doTimerPush(PushScene.DATA_INTERRUPT);
    }

    //@Scheduled(cron = "0 */10 * * * ?")
    public void registerSuccessNotUse() {
        pusher.doTimerPush(PushScene.REGISTER_SUCCESS_24H_NOT_USE);
    }

    //@Scheduled(cron = "0 */10 * * * ?")
    public void expireMeetRequest() {
        pusher.doTimerPush(PushScene.EXPIRE_MEET_REQUEST);
    }

    public void noLoveCondtion() {
        pusher.doTimerPush(PushScene.NO_LOVE_CONDTION);
    }

    //@Scheduled(cron = "0 0 12,19 * * ?")
    public void userLoveRemind() {
        pusher.doTimerPush(PushScene.LOVE_REMIND);
    }

//    @Scheduled(cron = "0 0/30 8-21 * * ?")
    public void meetGroupTimeoutFeedback() {
        pusher.doTimerPush(PushScene.MEET_TIMEOUT_FEEDBACK);
    }

    //@Scheduled(cron = "0 */10 * * * ?")
    public void activityStart() {
        pusher.doTimerPush(PushScene.ACTIVITY_START);
    }
}
