package com.bxm.lovelink.common.scheduler;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.Activity;
import com.bxm.lovelink.common.dal.service.IActivityService;
import com.bxm.lovelink.common.dal.service.IActivityUserMutualSelectionService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 活动结束生成互选结果定时任务
 * @author: weixing
 */
@Slf4j
@Component
public class ActivityEndMutualSelectResultScheduler {
    private final IActivityService activityService;
    private final IActivityUserMutualSelectionService activityUserMutualSelectionService;

    public ActivityEndMutualSelectResultScheduler(IActivityService activityService, IActivityUserMutualSelectionService activityUserMutualSelectionService) {
        this.activityService = activityService;
        this.activityUserMutualSelectionService = activityUserMutualSelectionService;
    }

//    @Scheduled(cron = "0 */3 * * * ?")
    public void schedule() {
        LocalDateTime now = LocalDateTime.now();
        List<Activity> list = activityService.list(new LambdaQueryWrapper<Activity>()
                .lt(Activity::getActivityEndTime, now)
                .eq(Activity::getActivityStatus, Constants.ActivityStatus.OPEN));
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (Activity activity : list) {
            // 生成互选结果
            activityUserMutualSelectionService.generateMutualSelectResult(activity.getId());
        }


    }
}
