package com.bxm.lovelink.common.scheduler;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.UserOrder;
import com.bxm.lovelink.common.dal.service.IActivityService;
import com.bxm.lovelink.common.dal.service.IUserOrderService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 活动订单超时未支付
 *
 * @author: weixing
 */
@Slf4j
@Component
public class ActivityOrderTimeoutScheduler {
    private final IUserOrderService userOrderService;
    private final IActivityService activityService;

    public ActivityOrderTimeoutScheduler(IUserOrderService userOrderService, IActivityService activityService) {
        this.userOrderService = userOrderService;
        this.activityService = activityService;
    }

//    @Scheduled(cron = "*/10 * * * * ?")
    public void schedule() {
        // 查询活动订单，未支付的超时订单，超过10分钟未支付
        List<UserOrder> userOrders = userOrderService.list(new LambdaQueryWrapper<UserOrder>()
                .lt(UserOrder::getStatus, Constants.UserOrder.STATUS_SUCCESS)
                .eq(UserOrder::getProductType, Constants.MeetTicketProduct.ACTIVITY_PAY)
                .lt(UserOrder::getCreateTime, LocalDateTime.now().minusMinutes(10)));
        if (CollectionUtils.isEmpty(userOrders)) {
            return;
        }
        log.info("释放{}笔超时未支付订单的活动名额", userOrders.size());
        for (UserOrder userOrder : userOrders) {
            try {
                activityService.releaseStock(userOrder.getOrderNum());
            } catch (Exception e) {
                log.error("活动订单超时未支付，释放活动名额失败, orderNum:{}",userOrder.getOrderNum(), e);
            }
        }
    }
}
