package com.bxm.lovelink.common.scheduler;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.MeetGroup;
import com.bxm.lovelink.common.dal.entity.dao.MeetGroupDao;
import com.bxm.lovelink.common.dal.manager.MeetGroupManager;
import com.bxm.lovelink.common.dal.service.IMeetGroupService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 查询邀请状态为待确认，且超时时间早于当前时间，则调用接口，更新状态为已过期
 *
 * @author Allen Hu
 * @date 2025/5/19
 */
@Slf4j
@Configuration
public class MeetGroupInviteTimeoutScheduler {

    private final IMeetGroupService meetGroupService;
    private final MeetGroupManager meetGroupManager;

    public MeetGroupInviteTimeoutScheduler(IMeetGroupService meetGroupService, MeetGroupManager meetGroupManager) {
        this.meetGroupService = meetGroupService;
        this.meetGroupManager = meetGroupManager;
    }

    @Scheduled(cron = "0 * * * * ?")
    public void schedule() {
        // TODO 使用多线程可以提高处理速度
        try {
            QueryWrapper<MeetGroup> queryWrapper = new QueryWrapper<MeetGroup>()
                    .eq(MeetGroup.GROUP_STATUS, Constants.MeetGroupConst.GroupStatus.WAIT_ACCEPT.value())
                    .lt(MeetGroup.INVITE_EXPIRE_TIME, LocalDateTime.now());
            List<MeetGroupDao> timeoutList = meetGroupService.listDao(queryWrapper);
            for (MeetGroupDao meetGroup : timeoutList) {
                try {
                    meetGroupManager.handleInviteTimeout(meetGroup);
                } catch (Exception e) {
                    log.error("handleInviteTimeout: {}", meetGroup, e);
                }
            }
        } catch (Exception e) {
            log.error("schedule:", e);
        }
    }
}
