package com.bxm.lovelink.common.scheduler;

import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

/**
 * 配置定时任务的线程池
 *
 * @author Allen Hu
 * @date 2025/7/4
 */
@Configuration
public class ScheduleConfig implements SchedulingConfigurer {

    private final int corePoolSize = Runtime.getRuntime().availableProcessors();

    @Override
    public void configureTasks(ScheduledTaskRegistrar registrar) {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(corePoolSize);
        scheduler.setThreadNamePrefix("scheduled-task-");
        scheduler.initialize();
        registrar.setTaskScheduler(scheduler);
    }
}
