package com.bxm.lovelink.common.scheduler;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.bxm.lovelink.common.dal.entity.UserAudit;
import com.bxm.lovelink.common.dal.service.IUserAuditService;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author zhangdong
 * @date 2025/5/20
 */
@Component
public class UserAuditScheduler {

    private final IUserAuditService userAuditService;

    public UserAuditScheduler(IUserAuditService userAuditService) {
        this.userAuditService = userAuditService;
    }

    @Scheduled(cron = "0 */5 * * * ?")
    public void auditAsync() {
        List<UserAudit> list = userAuditService.list(new LambdaUpdateWrapper<UserAudit>()
                .eq(UserAudit::getAuditStatus, UserAudit.STATUS_WAIT));
        list.forEach(userAuditService::audit);
    }
}
