package com.bxm.lovelink.common.scheduler;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.bxm.lovelink.common.dal.entity.UserCert;
import com.bxm.lovelink.common.dal.service.IUserCertService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author tangxiao
 * @date 2025/6/23
 */
@Component
@Slf4j
public class UserCertScheduler {

    private final IUserCertService userCertService;

    public UserCertScheduler(IUserCertService userCertService) {
        this.userCertService = userCertService;
    }

    @Scheduled(cron = "*/10 * * * * ?")
    public void updateCert() {
        List<UserCert> list = userCertService.list(new LambdaUpdateWrapper<UserCert>()
                .eq(UserCert::getCertStatus, UserCert.STATUS_CHECKING)
                .ne(UserCert::getCertType, UserCert.TYPE_REAL_NAME));
        list.forEach(u -> {
            try {
                userCertService.updateCertByApi(u);
            } catch (Exception e) {
                log.error("Update cert error ", e);
            }
        });
    }
}
