package com.bxm.lovelink.common.scheduler;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.UserOtherInfo;
import com.bxm.lovelink.common.dal.entity.pair.NewUserRule;
import com.bxm.lovelink.common.dal.service.IUserOtherInfoService;
import com.bxm.warcar.integration.pair.Pair;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zhangdong
 * @date 2025/6/24
 */
@Component
public class UserOldScheduler {

    private final IUserOtherInfoService userOtherInfoService;

    private final Pair pair;

    public UserOldScheduler(IUserOtherInfoService userOtherInfoService, Pair pair) {
        this.userOtherInfoService = userOtherInfoService;
        this.pair = pair;
    }


    @Scheduled(cron = "0 */5 * * * ?")
    public void newToOld() {
        NewUserRule newUserRule = JSON.parseObject(pair.get(Constants.PairKey.NEW_USER_RULE).of(), NewUserRule.class);
        List<UserOtherInfo> updates = userOtherInfoService.list(new LambdaQueryWrapper<UserOtherInfo>()
                .eq(UserOtherInfo::getNewUser, Constants.YES)
                .le(UserOtherInfo::getCreateTime, LocalDateTime.now().plusHours(-newUserRule.getExpireTime()))
                .select(UserOtherInfo::getId)).stream().map(x -> new UserOtherInfo().setId(x.getId()).setNewUser(Constants.NO)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(updates)) {
            userOtherInfoService.updateBatchById(updates);
        }
    }


}
