package com.bxm.lovelink.common.scheduler;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.UserOtherInfo;
import com.bxm.lovelink.common.dal.service.IUserOnlineService;
import com.bxm.lovelink.common.dal.service.IUserOtherInfoService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.pair.Pair;
import com.bxm.warcar.utils.NamedThreadFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @author zhangdong
 * @date 2025/6/24
 */
@Component
public class UserOnLineStatusScheduler {

    private final IUserOtherInfoService userOtherInfoService;
    private final ExecutorService executor;
    private final Fetcher fetcher;
    private final IUserOnlineService userOnlineService;

    public UserOnLineStatusScheduler(IUserOtherInfoService userOtherInfoService, Pair pair, Fetcher fetcher, IUserOnlineService userOnlineService) {
        this.userOtherInfoService = userOtherInfoService;
        this.fetcher = fetcher;
        this.userOnlineService = userOnlineService;
        this.executor = new ThreadPoolExecutor(20, 20, 0L, TimeUnit.MILLISECONDS,
                new LinkedBlockingQueue<>(), new NamedThreadFactory("user_online_status"));
    }


    @Scheduled(cron = "0 */5 * * * ?")
    public void noOnline() {
        Map<Long, Long> map = userOtherInfoService.list(new LambdaQueryWrapper<UserOtherInfo>()
                        .eq(UserOtherInfo::getOnlineStatus, Constants.YES)
                        .select(UserOtherInfo::getId, UserOtherInfo::getUserId))
                .stream().collect(Collectors.toMap(UserOtherInfo::getUserId, UserOtherInfo::getId));
        for (Map.Entry<Long, Long> entry : map.entrySet()) {
            Long userId = entry.getKey();
            Long otherId = entry.getValue();
            executor.execute(() -> {
                Boolean online = userOnlineService.getOnline(userId);
                if (!online) {
                    userOtherInfoService.update(new LambdaUpdateWrapper<UserOtherInfo>()
                            .eq(UserOtherInfo::getId, otherId)
                            .eq(UserOtherInfo::getOnlineStatus, Constants.YES)
                            .set(UserOtherInfo::getOnlineStatus, Constants.NO));
                }
            });
        }
    }


}
