package com.bxm.lovelink.common.utils;

import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangdong
 * @date 2025/5/19
 */
public class BitCalculateUtils {

    public static int calculate(List<Integer> bits) {
        if (CollectionUtils.isEmpty(bits)) {
            return 0;
        }
        int result = 0;
        for (Integer bit : bits) {
            result |= bit;
        }
        return result;
    }

    public static List<Integer> reverseCalculate(Integer result) {
        List<Integer> bits = new ArrayList<>();
        if (result == null) {
            return bits;
        }
        int bit = 1;
        while (result > 0) {
            if ((result & 1) == 1) {
                bits.add(bit);
            }
            result >>= 1;
            bit <<= 1;
        }
        return bits;
    }
}
