package com.bxm.lovelink.common.utils;

import com.bxm.acl.facade.AclAuthInterceptor;
import com.bxm.acl.facade.model.UserVo;

import javax.servlet.http.HttpServletRequest;

/**
 * 后台用户上下文
 * @author dll
 * @date 2025/4/29
 * @since 1.0
 */
public class CmsUserUtils {

    /**
     * 获取当前用户
     */
    public static UserVo getUser() {
        HttpServletRequest request = HttpServletUtils.getRequest();
        return (UserVo) request.getAttribute(AclAuthInterceptor.USER_KEY);
    }

    /**
     * 获取当前用户名
     */
    public static String getUserName() {
        UserVo user = getUser();
        if (user != null) {
            if (null != user.getId()) {
                return user.getUsername();
            }
        }
        return null;
    }
}
