package com.bxm.lovelink.common.utils;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;

import java.util.Collections;
import java.util.List;

/**
 * @param
 * @author
 * @version V1.0
 * @Description: excel读取
 * @date 2025/04/24 17:59
 * @return
 */
@Slf4j
public class ExcelDataListener<T> extends AnalysisEventListener<T> {

    List<T> list;

    /**
     * 这个每一条数据解析都会来调用
     *
     * @param data    one row value. Is is same as {@link AnalysisContext#readRowHolder()}
     * @param context
     */
    @Override
    public void invoke(T data, AnalysisContext context) {
//        LOGGER.info("解析到一条数据:{}", JSON.toJSONString(data));
        if (list == null) {
            list = Lists.newArrayList();
        }
        list.add(data);
    }

    /**
     * 所有数据解析完成了 都会来调用
     *
     * @param context
     */
    @Override
    public void doAfterAllAnalysed(AnalysisContext context) {
        // 这里也要保存数据，确保最后遗留的数据也存储到数据库
        log.info("所有数据解析完成！");
    }

    public List<T> getResult() {
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }
}