package com.bxm.lovelink.common.utils;

import com.alibaba.excel.EasyExcel;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;

@Slf4j
public class ExcelUtils {

    public static <T> void exportExcel(HttpServletResponse response, String title, Class<T> clazz, List<T> dataList) {
        try {
            String fileName = URLEncoder.encode(title, "UTF-8");
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
            EasyExcel.write(response.getOutputStream(), clazz).sheet(title).doWrite(dataList);
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("文件名转码失败");
        } catch (IOException e) {
            throw new RuntimeException("导出失败");
        }
    }

    /**
     * 读取excel
     *
     * @param pathName 文件路径
     * @param clazz    解析模版类
     * @param <T>
     * @return
     */
    public static <T> List<T> importExcelByPathName(String pathName, Class<T> clazz) {
        ExcelDataListener listener = new ExcelDataListener<T>();
        try {
            EasyExcel.read(pathName, clazz, listener).sheet().doRead();
            return listener.getResult();
        } catch (Exception e) {
            log.error("【excel-read】读取excel异常，clazz:{}", clazz, e);
        }
        return Collections.emptyList();
    }

    /**
     * 读取excel
     *
     * @param in    输入文件流
     * @param clazz 解析模版类
     * @param <T>
     * @return
     */
    public static <T> List<T> importExcelByIo(InputStream in, Class<T> clazz) {
        ExcelDataListener listener = new ExcelDataListener<T>();
        try {
            EasyExcel.read(in, clazz, listener).sheet().doRead();
            return listener.getResult();
        } catch (Exception e) {
            log.error("【excel-read】读取excel异常，clazz:{}", clazz, e);
        }
        return Collections.emptyList();
    }
}
