package com.bxm.lovelink.common.utils;

/**
 * @author zhangdong
 * @date 2025/5/22
 */
public class GeoDistanceUtils {

    // 地球平均半径（单位：米）
    private static final double EARTH_RADIUS = 6371000;

    /**
     * 计算两个经纬度之间的球面距离
     *
     * @param lat1 纬度1（单位：度）
     * @param lon1 经度1（单位：度）
     * @param lat2 纬度2（单位：度）
     * @param lon2 经度2（单位：度）
     * @return 距离（单位：米）
     */
    public static Double calculateDistance(Double lat1, Double lon1, Double lat2, Double lon2) {
        if (lat1 == null || lon1 == null || lat2 == null || lon2 == null) {
            return null;
        }
        // 将经纬度从度转换为弧度
        double radLat1 = Math.toRadians(lat1);
        double radLat2 = Math.toRadians(lat2);
        double deltaLat = radLat2 - radLat1;
        double deltaLon = Math.toRadians(lon2 - lon1);

        // Haversine公式
        double a = Math.sin(deltaLat / 2) * Math.sin(deltaLat / 2)
                + Math.cos(radLat1) * Math.cos(radLat2)
                * Math.sin(deltaLon / 2) * Math.sin(deltaLon / 2);
        double c = 2 * Math.asin(Math.sqrt(a));
        return EARTH_RADIUS * c;
    }

    // 示例使用
    public static void main(String[] args) {
        double lat1 = 39.9042;  // 北京
        double lon1 = 116.4074;
        double lat2 = 31.2304;  // 上海
        double lon2 = 121.4737;

        double distance = calculateDistance(lat1, lon1, lat2, lon2);
        System.out.printf("两地之间的距离为：%.2f 米%n", distance);
    }
}

