package com.bxm.lovelink.common.validator;


import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author Allen Hu
 * @date 2025/6/18
 */
@Constraint(validatedBy = AllowedIntValuesValidator.class)
@Target({ ElementType.FIELD, ElementType.PARAMETER })
@Retention(RetentionPolicy.RUNTIME)
public @interface AllowedIntValues {

    String message() default "必须是 -1, 0 或 1";
    Class<?>[] groups() default {};
    Class<? extends Payload>[] payload() default {};

    int[] value();
}
