package com.bxm.lovelink.common.validator;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * @author Allen Hu
 * @date 2025/6/18
 */
public class AllowedIntValuesValidator implements ConstraintValidator<AllowedIntValues, Integer> {

    private int[] allowedValues;

    @Override
    public void initialize(AllowedIntValues constraintAnnotation) {
        this.allowedValues = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(Integer value, ConstraintValidatorContext context) {
        if (value == null) {
            return true; // 如果允许 null 值
        }
        for (int allowedValue : allowedValues) {
            if (value == allowedValue) {
                return true;
            }
        }
        return false;
    }
}