/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.autoconfigure;

import com.bxm.lovelink.common.chat.ChatService;
import com.bxm.lovelink.common.chat.CozeChatServiceImpl;
import com.bxm.lovelink.common.chat.coze.CozeJWTOAuth;
import com.bxm.lovelink.common.chat.coze.CozeProperties;
import com.bxm.lovelink.common.chat.coze.MessageConvertFactory;
import com.bxm.warcar.integration.eventbus.EventPark;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableConfigurationProperties(value={CozeProperties.class})
@ConditionalOnProperty(prefix="lovelink.coze", name={"enabled"}, havingValue="true")
public class CozeAutoConfiguration {
    @Bean
    public CozeJWTOAuth cozeJWTOAuth(CozeProperties properties) {
        return new CozeJWTOAuth(properties.getClientId(), properties.getPrivateKeyFileResource(), properties.getPublicKeyId());
    }

    @Bean
    @Primary
    public ChatService cozeChatServiceImpl(CozeJWTOAuth cozeJWTOAuth, CozeProperties cozeProperties, EventPark eventPark, MessageConvertFactory messageConvertFactory) {
        return new CozeChatServiceImpl(cozeJWTOAuth, cozeProperties, eventPark, messageConvertFactory);
    }
}

