/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.cache;

import com.bxm.lovelink.common.exception.BusinessException;
import com.bxm.lovelink.constant.RedisKeys;
import com.bxm.warcar.cache.DataExtractor;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.bxm.warcar.xcache.Target;
import com.bxm.warcar.xcache.TargetFactory;
import com.bxm.warcar.xcache.fetchers.LoadingCacheFetcher;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;

public abstract class AbstractTableCache<T> {
    private final Fetcher fetcher;
    private final Updater updater;
    private final RedissonClient redissonClient;
    private final LoadingCacheFetcher loadingCacheFetcher;
    private final ThreadPoolExecutor executor;

    public AbstractTableCache(Fetcher fetcher, Updater updater, RedissonClient redissonClient, LoadingCacheFetcher loadingCacheFetcher) {
        this.fetcher = fetcher;
        this.updater = updater;
        this.redissonClient = redissonClient;
        this.loadingCacheFetcher = loadingCacheFetcher;
        this.executor = new ThreadPoolExecutor(50, 100, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), (ThreadFactory)new NamedThreadFactory("cache-executor"));
    }

    public abstract KeyGenerator getKeyGenerator(Long var1);

    public abstract T getFromDatabase(Long var1);

    public abstract Class<T> getCacheClass();

    protected boolean isLockingForUpdate() {
        return true;
    }

    protected int getExpireTime() {
        return 600;
    }

    public T getFromCache(Long userId) {
        return (T)this.fetcher.fetch(this.getKeyGenerator(userId), this.getCacheClass());
    }

    public T getFromCache(Long userId, DataExtractor<T> dataExtractor) {
        return (T)this.fetcher.fetch(this.getKeyGenerator(userId), dataExtractor, this.getCacheClass(), this.getExpireTime());
    }

    public void removeCache(Long userId) {
        if (Objects.isNull(userId)) {
            return;
        }
        this.updater.remove(this.getKeyGenerator(userId));
    }

    public void preparationAfterRemoved(Long userId) {
        if (Objects.isNull(userId)) {
            return;
        }
        this.removeCache(userId);
        this.getIfNullFromDatabase(userId);
    }

    public List<T> getBatchFromAuto(List<Long> userIds) {
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isEmpty(userIds)) {
            return list;
        }
        if (userIds.size() == 1) {
            return Lists.newArrayList((Object[])new Object[]{this.getFromAuto(userIds.get(0))});
        }
        CountDownLatch countDownLatch = new CountDownLatch(userIds.size());
        ArrayList futures = Lists.newArrayList();
        for (Long userId : userIds) {
            futures.add(this.executor.submit(() -> {
                try {
                    T t = this.getFromAuto(userId);
                    return t;
                }
                finally {
                    countDownLatch.countDown();
                }
            }));
        }
        try {
            countDownLatch.await();
        }
        catch (Exception e) {
            throw new BusinessException("cache wait error");
        }
        boolean hasError = false;
        for (Future future : futures) {
            if (future.isDone()) {
                try {
                    Object t = future.get();
                    if (t == null) continue;
                    list.add(future.get());
                }
                catch (Exception e) {
                    hasError = true;
                }
                continue;
            }
            hasError = true;
        }
        if (hasError) {
            throw new BusinessException("cache error");
        }
        return list;
    }

    public T getFromAuto(Long userId) {
        Integer isFromCache = 1;
        try {
            Target target = new TargetFactory().keyGenerator(RedisKeys.cacheMark()).cls(Integer.class).build();
            isFromCache = (Integer)this.loadingCacheFetcher.fetch(target);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Objects.equals(isFromCache, 1)) {
            return this.getIfNullFromDatabase(userId);
        }
        return this.getFromDatabase(userId);
    }

    public T getIfNullFromDatabase(Long userId) {
        if (this.isLockingForUpdate()) {
            return this.getIfNullFromDatabaseOnLock(userId);
        }
        return this.getIfNullFromDatabaseOutLock(userId);
    }

    private T getIfNullFromDatabaseOutLock(Long userId) {
        return this.getFromCache(userId, () -> this.getFromDatabase(userId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getIfNullFromDatabaseOnLock(Long userId) {
        T t = this.getFromCache(userId);
        if (t != null) {
            return t;
        }
        String key = userId + ":" + this.getClass().getSimpleName();
        RLock lock = this.redissonClient.getLock(RedisKeys.cacheSyncLock((String)key).generateKey());
        boolean b = false;
        try {
            b = lock.tryLock();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!b) {
            return this.getFromDatabase(userId);
        }
        try {
            T t2 = this.getFromCache(userId, () -> this.getFromDatabase(userId));
            return t2;
        }
        finally {
            lock.unlock();
        }
    }
}

