/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.cache;

import com.bxm.lovelink.common.cache.AbstractTableCache;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.service.IUserBasicInfoService;
import com.bxm.lovelink.constant.RedisKeys;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.xcache.fetchers.LoadingCacheFetcher;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Component;

@Component
public class UserBasicInfoTableCache
extends AbstractTableCache<UserBasicInfo> {
    private final IUserBasicInfoService userBasicInfoService;

    public UserBasicInfoTableCache(RedissonClient redissonClient, Fetcher fetcher, Updater updater, IUserBasicInfoService userBasicInfoService, LoadingCacheFetcher loadingCacheFetcher) {
        super(fetcher, updater, redissonClient, loadingCacheFetcher);
        this.userBasicInfoService = userBasicInfoService;
    }

    @Override
    public KeyGenerator getKeyGenerator(Long userId) {
        return RedisKeys.userBasicInfoCache((Long)userId);
    }

    @Override
    public UserBasicInfo getFromDatabase(Long userId) {
        return this.userBasicInfoService.getOneByUserId(userId);
    }

    @Override
    public Class<UserBasicInfo> getCacheClass() {
        return UserBasicInfo.class;
    }
}

