/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.cache;

import com.bxm.lovelink.common.cache.AbstractTableCache;
import com.bxm.lovelink.common.dal.entity.User;
import com.bxm.lovelink.common.dal.service.IUserService;
import com.bxm.lovelink.constant.RedisKeys;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.xcache.fetchers.LoadingCacheFetcher;
import java.time.Duration;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Service;

@Service
public class UserId2NumberMappingCache
extends AbstractTableCache<String> {
    private final IUserService userService;

    public UserId2NumberMappingCache(Fetcher fetcher, Updater updater, RedissonClient redissonClient, LoadingCacheFetcher loadingCacheFetcher, IUserService userService) {
        super(fetcher, updater, redissonClient, loadingCacheFetcher);
        this.userService = userService;
    }

    @Override
    public KeyGenerator getKeyGenerator(Long userId) {
        return RedisKeys.stringUserId2UserNumberMapping((Long)userId);
    }

    @Override
    public String getFromDatabase(Long userId) {
        User user = (User)this.userService.getById(userId);
        if (user == null) {
            return null;
        }
        return user.getUserNumber();
    }

    @Override
    public Class<String> getCacheClass() {
        return String.class;
    }

    @Override
    protected boolean isLockingForUpdate() {
        return false;
    }

    @Override
    protected int getExpireTime() {
        return (int)Duration.ofDays(30L).getSeconds();
    }
}

