/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.cache;

import com.bxm.lovelink.common.cache.AbstractTableCache;
import com.bxm.lovelink.common.dal.entity.UserOtherInfo;
import com.bxm.lovelink.common.dal.service.IUserOtherInfoService;
import com.bxm.lovelink.constant.RedisKeys;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.xcache.fetchers.LoadingCacheFetcher;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Component;

@Component
public class UserOtherTableCache
extends AbstractTableCache<UserOtherInfo> {
    private final IUserOtherInfoService userOtherInfoService;

    public UserOtherTableCache(RedissonClient redissonClient, Fetcher fetcher, Updater updater, IUserOtherInfoService userOtherInfoService, LoadingCacheFetcher loadingCacheFetcher) {
        super(fetcher, updater, redissonClient, loadingCacheFetcher);
        this.userOtherInfoService = userOtherInfoService;
    }

    @Override
    public KeyGenerator getKeyGenerator(Long userId) {
        return RedisKeys.userOtherCache((Long)userId);
    }

    @Override
    public UserOtherInfo getFromDatabase(Long userId) {
        return this.userOtherInfoService.getOneByUserId(userId);
    }

    @Override
    public Class<UserOtherInfo> getCacheClass() {
        return UserOtherInfo.class;
    }
}

