/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.cache;

import com.bxm.lovelink.common.cache.AbstractTableCache;
import com.bxm.lovelink.common.dal.entity.User;
import com.bxm.lovelink.common.dal.service.IUserService;
import com.bxm.lovelink.constant.RedisKeys;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.xcache.fetchers.LoadingCacheFetcher;
import org.redisson.api.RedissonClient;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class UserTableCache
extends AbstractTableCache<User> {
    private final IUserService userService;

    public UserTableCache(RedissonClient redissonClient, Fetcher fetcher, Updater updater, @Lazy IUserService userService, LoadingCacheFetcher loadingCacheFetcher) {
        super(fetcher, updater, redissonClient, loadingCacheFetcher);
        this.userService = userService;
    }

    @Override
    public KeyGenerator getKeyGenerator(Long userId) {
        return RedisKeys.userCache((Long)userId);
    }

    @Override
    public User getFromDatabase(Long userId) {
        return (User)this.userService.getById(userId);
    }

    @Override
    public Class<User> getCacheClass() {
        return User.class;
    }
}

