/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.chat;

import com.bxm.lovelink.common.chat.ByteWriter;
import com.bxm.lovelink.common.chat.CompleteConsumer;
import com.bxm.lovelink.common.chat.SimpleHandler;
import com.bxm.lovelink.common.chat.SseEventData;
import com.bxm.lovelink.common.dal.entity.ChatSession;
import com.bxm.lovelink.common.dal.entity.ChatSessionMessage;
import com.bxm.lovelink.common.dal.entity.User;
import com.bxm.warcar.utils.JsonHelper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.catalina.connector.ClientAbortException;
import org.springframework.lang.Nullable;

public class ChatRequest {
    private User user;
    private ChatSession chatSession;
    private List<ChatSessionMessage> chatSessionMessages;
    private Map<String, Object> parameter;
    @Nullable
    private ByteWriter<byte[]> writeConsumer;
    @Nullable
    private SimpleHandler flusher;
    @Nullable
    private CompleteConsumer complete;
    @Nullable
    private BiConsumer<ClientAbortException, String> clientAbortExceptionStringBiConsumer;

    public void doWriteAndFlush(byte[] bytes) throws IOException {
        this.doWrite(bytes);
        this.doFlush();
    }

    public void doWriteAndFlush(String content) throws IOException {
        if (null != content) {
            byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
            this.doWriteAndFlush(bytes);
        }
    }

    public void doWriteAndFlush(SseEventData sseEventData) throws IOException {
        this.doWriteAndFlush(JsonHelper.convert((Object)sseEventData));
    }

    public void doWriteAndFlushQuietly(SseEventData sseEventData) {
        try {
            this.doWriteAndFlush(sseEventData);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void doWrite(byte[] bytes) throws IOException {
        if (this.writeConsumer != null) {
            this.writeConsumer.write(bytes);
        }
    }

    public void doFlush() {
        if (this.flusher != null) {
            try {
                this.flusher.execute();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void doComplete(List<ChatSessionMessage> messages) {
        if (this.complete != null) {
            this.complete.accept(messages);
        }
    }

    ChatRequest(User user, ChatSession chatSession, List<ChatSessionMessage> chatSessionMessages, Map<String, Object> parameter, @Nullable ByteWriter<byte[]> writeConsumer, @Nullable SimpleHandler flusher, @Nullable CompleteConsumer complete, @Nullable BiConsumer<ClientAbortException, String> clientAbortExceptionStringBiConsumer) {
        this.user = user;
        this.chatSession = chatSession;
        this.chatSessionMessages = chatSessionMessages;
        this.parameter = parameter;
        this.writeConsumer = writeConsumer;
        this.flusher = flusher;
        this.complete = complete;
        this.clientAbortExceptionStringBiConsumer = clientAbortExceptionStringBiConsumer;
    }

    public static ChatRequestBuilder builder() {
        return new ChatRequestBuilder();
    }

    public User getUser() {
        return this.user;
    }

    public ChatSession getChatSession() {
        return this.chatSession;
    }

    public List<ChatSessionMessage> getChatSessionMessages() {
        return this.chatSessionMessages;
    }

    public Map<String, Object> getParameter() {
        return this.parameter;
    }

    @Nullable
    public ByteWriter<byte[]> getWriteConsumer() {
        return this.writeConsumer;
    }

    @Nullable
    public SimpleHandler getFlusher() {
        return this.flusher;
    }

    @Nullable
    public CompleteConsumer getComplete() {
        return this.complete;
    }

    @Nullable
    public BiConsumer<ClientAbortException, String> getClientAbortExceptionStringBiConsumer() {
        return this.clientAbortExceptionStringBiConsumer;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setChatSession(ChatSession chatSession) {
        this.chatSession = chatSession;
    }

    public void setChatSessionMessages(List<ChatSessionMessage> chatSessionMessages) {
        this.chatSessionMessages = chatSessionMessages;
    }

    public void setParameter(Map<String, Object> parameter) {
        this.parameter = parameter;
    }

    public void setWriteConsumer(@Nullable ByteWriter<byte[]> writeConsumer) {
        this.writeConsumer = writeConsumer;
    }

    public void setFlusher(@Nullable SimpleHandler flusher) {
        this.flusher = flusher;
    }

    public void setComplete(@Nullable CompleteConsumer complete) {
        this.complete = complete;
    }

    public void setClientAbortExceptionStringBiConsumer(@Nullable BiConsumer<ClientAbortException, String> clientAbortExceptionStringBiConsumer) {
        this.clientAbortExceptionStringBiConsumer = clientAbortExceptionStringBiConsumer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatRequest)) {
            return false;
        }
        ChatRequest other = (ChatRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        ChatSession this$chatSession = this.getChatSession();
        ChatSession other$chatSession = other.getChatSession();
        if (this$chatSession == null ? other$chatSession != null : !((Object)this$chatSession).equals(other$chatSession)) {
            return false;
        }
        List<ChatSessionMessage> this$chatSessionMessages = this.getChatSessionMessages();
        List<ChatSessionMessage> other$chatSessionMessages = other.getChatSessionMessages();
        if (this$chatSessionMessages == null ? other$chatSessionMessages != null : !((Object)this$chatSessionMessages).equals(other$chatSessionMessages)) {
            return false;
        }
        Map<String, Object> this$parameter = this.getParameter();
        Map<String, Object> other$parameter = other.getParameter();
        if (this$parameter == null ? other$parameter != null : !((Object)this$parameter).equals(other$parameter)) {
            return false;
        }
        ByteWriter<byte[]> this$writeConsumer = this.getWriteConsumer();
        ByteWriter<byte[]> other$writeConsumer = other.getWriteConsumer();
        if (this$writeConsumer == null ? other$writeConsumer != null : !this$writeConsumer.equals(other$writeConsumer)) {
            return false;
        }
        SimpleHandler this$flusher = this.getFlusher();
        SimpleHandler other$flusher = other.getFlusher();
        if (this$flusher == null ? other$flusher != null : !this$flusher.equals(other$flusher)) {
            return false;
        }
        CompleteConsumer this$complete = this.getComplete();
        CompleteConsumer other$complete = other.getComplete();
        if (this$complete == null ? other$complete != null : !this$complete.equals(other$complete)) {
            return false;
        }
        BiConsumer<ClientAbortException, String> this$clientAbortExceptionStringBiConsumer = this.getClientAbortExceptionStringBiConsumer();
        BiConsumer<ClientAbortException, String> other$clientAbortExceptionStringBiConsumer = other.getClientAbortExceptionStringBiConsumer();
        return !(this$clientAbortExceptionStringBiConsumer == null ? other$clientAbortExceptionStringBiConsumer != null : !this$clientAbortExceptionStringBiConsumer.equals(other$clientAbortExceptionStringBiConsumer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        ChatSession $chatSession = this.getChatSession();
        result = result * 59 + ($chatSession == null ? 43 : ((Object)$chatSession).hashCode());
        List<ChatSessionMessage> $chatSessionMessages = this.getChatSessionMessages();
        result = result * 59 + ($chatSessionMessages == null ? 43 : ((Object)$chatSessionMessages).hashCode());
        Map<String, Object> $parameter = this.getParameter();
        result = result * 59 + ($parameter == null ? 43 : ((Object)$parameter).hashCode());
        ByteWriter<byte[]> $writeConsumer = this.getWriteConsumer();
        result = result * 59 + ($writeConsumer == null ? 43 : $writeConsumer.hashCode());
        SimpleHandler $flusher = this.getFlusher();
        result = result * 59 + ($flusher == null ? 43 : $flusher.hashCode());
        CompleteConsumer $complete = this.getComplete();
        result = result * 59 + ($complete == null ? 43 : $complete.hashCode());
        BiConsumer<ClientAbortException, String> $clientAbortExceptionStringBiConsumer = this.getClientAbortExceptionStringBiConsumer();
        result = result * 59 + ($clientAbortExceptionStringBiConsumer == null ? 43 : $clientAbortExceptionStringBiConsumer.hashCode());
        return result;
    }

    public String toString() {
        return "ChatRequest(user=" + this.getUser() + ", chatSession=" + this.getChatSession() + ", chatSessionMessages=" + this.getChatSessionMessages() + ", parameter=" + this.getParameter() + ", writeConsumer=" + this.getWriteConsumer() + ", flusher=" + this.getFlusher() + ", complete=" + this.getComplete() + ", clientAbortExceptionStringBiConsumer=" + this.getClientAbortExceptionStringBiConsumer() + ")";
    }

    public static class ChatRequestBuilder {
        private User user;
        private ChatSession chatSession;
        private List<ChatSessionMessage> chatSessionMessages;
        private Map<String, Object> parameter;
        private ByteWriter<byte[]> writeConsumer;
        private SimpleHandler flusher;
        private CompleteConsumer complete;
        private BiConsumer<ClientAbortException, String> clientAbortExceptionStringBiConsumer;

        ChatRequestBuilder() {
        }

        public ChatRequestBuilder user(User user) {
            this.user = user;
            return this;
        }

        public ChatRequestBuilder chatSession(ChatSession chatSession) {
            this.chatSession = chatSession;
            return this;
        }

        public ChatRequestBuilder chatSessionMessages(List<ChatSessionMessage> chatSessionMessages) {
            this.chatSessionMessages = chatSessionMessages;
            return this;
        }

        public ChatRequestBuilder parameter(Map<String, Object> parameter) {
            this.parameter = parameter;
            return this;
        }

        public ChatRequestBuilder writeConsumer(@Nullable ByteWriter<byte[]> writeConsumer) {
            this.writeConsumer = writeConsumer;
            return this;
        }

        public ChatRequestBuilder flusher(@Nullable SimpleHandler flusher) {
            this.flusher = flusher;
            return this;
        }

        public ChatRequestBuilder complete(@Nullable CompleteConsumer complete) {
            this.complete = complete;
            return this;
        }

        public ChatRequestBuilder clientAbortExceptionStringBiConsumer(@Nullable BiConsumer<ClientAbortException, String> clientAbortExceptionStringBiConsumer) {
            this.clientAbortExceptionStringBiConsumer = clientAbortExceptionStringBiConsumer;
            return this;
        }

        public ChatRequest build() {
            return new ChatRequest(this.user, this.chatSession, this.chatSessionMessages, this.parameter, this.writeConsumer, this.flusher, this.complete, this.clientAbortExceptionStringBiConsumer);
        }

        public String toString() {
            return "ChatRequest.ChatRequestBuilder(user=" + this.user + ", chatSession=" + this.chatSession + ", chatSessionMessages=" + this.chatSessionMessages + ", parameter=" + this.parameter + ", writeConsumer=" + this.writeConsumer + ", flusher=" + this.flusher + ", complete=" + this.complete + ", clientAbortExceptionStringBiConsumer=" + this.clientAbortExceptionStringBiConsumer + ")";
        }
    }
}

