/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.chat;

import cn.hutool.core.collection.ConcurrentHashSet;
import com.alibaba.fastjson.JSONObject;
import com.bxm.lovelink.common.chat.ChatException;
import com.bxm.lovelink.common.chat.ChatFailedException;
import com.bxm.lovelink.common.chat.ChatRequest;
import com.bxm.lovelink.common.chat.ChatService;
import com.bxm.lovelink.common.chat.ChatStat;
import com.bxm.lovelink.common.chat.SseEventData;
import com.bxm.lovelink.common.chat.coze.CozeJWTOAuth;
import com.bxm.lovelink.common.chat.coze.CozeProperties;
import com.bxm.lovelink.common.chat.coze.MessageConvert;
import com.bxm.lovelink.common.chat.coze.MessageConvertFactory;
import com.bxm.lovelink.common.dal.entity.ChatSession;
import com.bxm.lovelink.common.dal.entity.ChatSessionMessage;
import com.bxm.lovelink.common.dal.entity.User;
import com.bxm.lovelink.common.event.chat.ChatCompletionEvent;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.utils.UUIDHelper;
import com.coze.openapi.client.chat.CancelChatReq;
import com.coze.openapi.client.chat.CreateChatReq;
import com.coze.openapi.client.chat.model.Chat;
import com.coze.openapi.client.chat.model.ChatEvent;
import com.coze.openapi.client.chat.model.ChatEventType;
import com.coze.openapi.client.connversations.message.model.Message;
import com.coze.openapi.client.connversations.message.model.MessageRole;
import com.coze.openapi.service.auth.Auth;
import com.coze.openapi.service.service.CozeAPI;
import com.google.common.collect.Maps;
import io.reactivex.functions.Consumer;
import java.io.InterruptedIOException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CozeChatServiceImpl
implements ChatService {
    private static final Logger log = LoggerFactory.getLogger(CozeChatServiceImpl.class);
    private final CozeJWTOAuth cozeJWTOAuth;
    private final CozeProperties cozeProperties;
    private final EventPark eventPark;
    private final MessageConvertFactory messageConvertFactory;
    private final ConcurrentHashSet<String> stopping = new ConcurrentHashSet();

    public CozeChatServiceImpl(CozeJWTOAuth cozeJWTOAuth, CozeProperties cozeProperties, EventPark eventPark, MessageConvertFactory messageConvertFactory) {
        this.cozeJWTOAuth = cozeJWTOAuth;
        this.cozeProperties = cozeProperties;
        this.eventPark = eventPark;
        this.messageConvertFactory = messageConvertFactory;
    }

    @Override
    public void cancel(String conversionId) {
        this.stopping.add((Object)conversionId);
    }

    private boolean isLogging(ChatRequest request) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stream(final ChatRequest request) {
        block10: {
            ChatSession chatSession = request.getChatSession();
            User user = request.getUser();
            List<ChatSessionMessage> chatSessionMessages = request.getChatSessionMessages();
            List<Message> messageList = this.convert2Message(chatSessionMessages);
            final String conversionId = UUIDHelper.generate();
            final ChatStat chatStat = new ChatStat();
            final StringBuilder reasoningContentBuilder = new StringBuilder();
            final StringBuilder contentBuilder = new StringBuilder();
            String botId = this.cozeProperties.getBotId();
            String userId = "LOVELINK-" + user.getId();
            CozeAPI coze = new CozeAPI.Builder().baseURL("https://api.coze.cn").auth((Auth)this.cozeJWTOAuth.build()).readTimeout((int)Duration.ofMinutes(5L).toMillis()).build();
            try {
                request.doWriteAndFlush(SseEventData.builder().status("0").time(SseEventData.getNowTimeString()).conversionId(conversionId).build());
                HashMap varMaps = Maps.newHashMap();
                Map parameters = Optional.ofNullable(request.getParameter()).orElseGet(HashMap::new);
                CreateChatReq chatReq = CreateChatReq.builder().botID(botId).userID(userId).stream(Boolean.valueOf(true)).conversationID(chatSession.getCozeConversationId()).customVariables((Map)varMaps).parameters(parameters).messages(messageList).build();
                if (this.isLogging(request)) {
                    log.info("[COZE] {} - {}", (Object)conversionId, (Object)JSONObject.toJSONString((Object)chatReq));
                }
                ChatEvent chatEvent = (ChatEvent)coze.chat().stream(chatReq).doOnRequest(t -> request.doWriteAndFlush(SseEventData.builder().status("1").time(SseEventData.getNowTimeString()).conversionId(conversionId).build())).doOnNext((Consumer)new Consumer<ChatEvent>(){

                    public void accept(ChatEvent chatEvent) throws Exception {
                        ChatEventType event = chatEvent.getEvent();
                        Message message = chatEvent.getMessage();
                        this.setChatStatValues(chatStat, message);
                        boolean onEventChatInProgress = ChatEventType.CONVERSATION_CHAT_IN_PROGRESS.equals(event);
                        boolean onEventMessageDelta = ChatEventType.CONVERSATION_MESSAGE_DELTA.equals(event);
                        if ((onEventChatInProgress || onEventMessageDelta) && CozeChatServiceImpl.this.stopping.contains((Object)conversionId)) {
                            throw new InterruptedException("User canceled the conversation");
                        }
                        if (onEventMessageDelta) {
                            String reasoningContent = message.getReasoningContent();
                            String content = message.getContent();
                            if (StringUtils.isNotBlank((CharSequence)reasoningContent)) {
                                reasoningContentBuilder.append(reasoningContent);
                                request.doWriteAndFlush(SseEventData.builder().status("2").time(SseEventData.getNowTimeString()).conversionId(conversionId).reasoningContent(reasoningContent).build());
                            }
                            if (StringUtils.isNotBlank((CharSequence)content)) {
                                contentBuilder.append(content);
                                request.doWriteAndFlush(SseEventData.builder().status("2").time(SseEventData.getNowTimeString()).conversionId(conversionId).content(content).build());
                            }
                        } else {
                            if (ChatEventType.CONVERSATION_CHAT_FAILED.equals(event)) {
                                Chat chat = chatEvent.getChat();
                                throw new ChatFailedException(chat.getLastError().toString());
                            }
                            log.debug("other event: {} - {}", (Object)event.getValue(), (Object)message);
                        }
                    }

                    private void setChatStatValues(ChatStat chatStat2, Message message) {
                        if (Objects.nonNull(message)) {
                            if (StringUtils.isNotBlank((CharSequence)message.getChatId())) {
                                chatStat2.setCozeChatId(message.getChatId());
                            }
                            if (StringUtils.isNotBlank((CharSequence)message.getBotId())) {
                                chatStat2.setCozeBotId(message.getBotId());
                            }
                            if (StringUtils.isNotBlank((CharSequence)message.getConversationId())) {
                                chatStat2.setCozeConversationId(message.getConversationId());
                            }
                        }
                    }
                }).lastElement().blockingGet();
                if (this.isLogging(request)) {
                    log.info("[COZE] {} - Reasoning: {} | Content: {}", new Object[]{conversionId, reasoningContentBuilder, contentBuilder});
                }
            }
            catch (Exception e) {
                SseEventData errorSseData = SseEventData.builder().status("3").time(SseEventData.getNowTimeString()).conversionId(conversionId).error(e.getMessage()).build();
                if (e instanceof ChatFailedException) {
                    log.error("Chat Fail: {}", (Object)e.getMessage());
                    request.doWriteAndFlushQuietly(errorSseData);
                    throw new ChatException(e);
                }
                Throwable cause = e.getCause();
                if (cause instanceof InterruptedIOException) {
                    request.doWriteAndFlushQuietly(errorSseData);
                    throw new ChatFailedException("IO Error");
                }
                if (cause instanceof ClientAbortException || cause instanceof InterruptedException) {
                    this.cancelQuietly(chatStat, coze);
                    break block10;
                }
                log.error("call coze error: ", (Throwable)e);
                request.doWriteAndFlushQuietly(errorSseData);
                throw new ChatException(e);
            }
            finally {
                this.stopping.remove((Object)conversionId);
                ChatSessionMessage chatSessionMessage = new ChatSessionMessage().setSessionId(chatSession.getId()).setRole(MessageRole.ASSISTANT.getValue()).setContentType(1).setReasoningContent(reasoningContentBuilder.toString()).setContent(contentBuilder.toString()).setCreateTime(LocalDateTime.now());
                chatSessionMessages.add(chatSessionMessage);
                request.doComplete(chatSessionMessages);
                ChatCompletionEvent chatCompletionEvent = new ChatCompletionEvent(this, request.getUser(), chatSession, chatSessionMessages, reasoningContentBuilder.toString(), contentBuilder.toString(), chatStat);
                this.eventPark.post((EventObject)chatCompletionEvent);
            }
        }
    }

    private void cancelQuietly(ChatStat chatStat, CozeAPI coze) {
        try {
            CancelChatReq cancelChatReq = CancelChatReq.builder().chatID(chatStat.getCozeChatId()).conversationID(chatStat.getCozeConversationId()).build();
            coze.chat().cancel(cancelChatReq);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List<Message> convert2Message(List<ChatSessionMessage> messages) {
        return messages.stream().map(message -> {
            Integer contentType = message.getContentType();
            MessageConvert messageConvert = (MessageConvert)this.messageConvertFactory.get(contentType);
            if (messageConvert == null) {
                log.warn("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6d88\u606f\u8f6c\u6362\u5668\uff0ccontentType: {}", (Object)contentType);
                return null;
            }
            Message msg = messageConvert.convert((ChatSessionMessage)message);
            msg.setRole(MessageRole.fromString((String)message.getRole()));
            return msg;
        }).collect(Collectors.toList());
    }
}

