/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.chat.coze;

import cn.hutool.core.io.IoUtil;
import com.coze.openapi.client.auth.OAuthToken;
import com.coze.openapi.service.auth.JWTOAuth;
import com.coze.openapi.service.auth.JWTOAuthClient;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class CozeJWTOAuth
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(CozeJWTOAuth.class);
    private final String clientId;
    private final Resource privateKeyFileResource;
    private final String publicKeyId;
    private JWTOAuthClient oauth;

    public CozeJWTOAuth(String clientId, Resource privateKeyFileResource, String publicKeyId) {
        this.clientId = clientId;
        this.privateKeyFileResource = privateKeyFileResource;
        this.publicKeyId = publicKeyId;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            byte[] bytes = IoUtil.readBytes((InputStream)this.privateKeyFileResource.getInputStream());
            String jwtOauthPrivateKey = new String(bytes, StandardCharsets.UTF_8);
            this.oauth = ((JWTOAuthClient.JWTOAuthBuilder)((JWTOAuthClient.JWTOAuthBuilder)new JWTOAuthClient.JWTOAuthBuilder().clientID(this.clientId)).privateKey(jwtOauthPrivateKey).publicKey(this.publicKeyId).baseURL("https://api.coze.cn")).build();
            log.info("coze oauth build success");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JWTOAuth build() {
        return JWTOAuth.builder().jwtClient(this.oauth).build();
    }

    public OAuthToken getAccessToken() {
        return this.oauth.getAccessToken();
    }

    public static void main(String[] args) throws Exception {
        FileSystemResource resource = new FileSystemResource("/Users/huxiao/Downloads/private_key.pem");
        CozeJWTOAuth jwt = new CozeJWTOAuth("1165922270501", (Resource)resource, "ZwhIrDxEecP_wLLfs4P9I4z6HkF-okx6J090V9CUhCw");
        jwt.afterPropertiesSet();
        System.out.println(jwt.getAccessToken());
        System.out.println(jwt.getAccessToken());
        System.out.println(jwt.getAccessToken());
    }
}

