/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.chat.coze;

import com.alibaba.fastjson.JSONObject;
import com.bxm.lovelink.common.chat.Attachment;
import com.bxm.lovelink.common.chat.coze.MessageConvert;
import com.bxm.lovelink.common.dal.entity.ChatSessionMessage;
import com.coze.openapi.client.connversations.message.model.Message;
import com.coze.openapi.client.connversations.message.model.MessageContentType;
import com.coze.openapi.client.connversations.message.model.MessageObjectString;
import com.coze.openapi.service.utils.Utils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ImageTextMessageConvert
implements MessageConvert {
    @Override
    public int contentType() {
        return 2;
    }

    @Override
    public boolean ignore() {
        return false;
    }

    @Override
    public Message convert(ChatSessionMessage message) {
        Message e = new Message();
        String content = message.getContent();
        String attachments = message.getAttachments();
        List attachmentList = null;
        if (StringUtils.isNotBlank((CharSequence)attachments)) {
            attachmentList = JSONObject.parseArray((String)attachments, Attachment.class);
        }
        if (CollectionUtils.isNotEmpty(attachmentList)) {
            ArrayList contents = Lists.newArrayList();
            MessageObjectString text = MessageObjectString.buildText((String)content);
            contents.add(text);
            for (Attachment attachVo : attachmentList) {
                MessageObjectString image = MessageObjectString.buildImageByURL((String)attachVo.getUrl());
                contents.add(image);
            }
            e.setContentType(MessageContentType.OBJECT_STRING);
            e.setContent(Utils.toJson((Object)contents));
        } else {
            e.setContentType(MessageContentType.TEXT);
            e.setContent(content);
        }
        return e;
    }
}

