/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.contant;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.collections.CollectionUtils;

public interface UserConstants {
    public static <E extends Enum<E>> String getNameByCode(Class<E> enumClass, Integer code) {
        if (code == null) {
            return null;
        }
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            if (!code.equals(((BaseEnum)((Object)e)).getCode())) continue;
            return ((BaseEnum)((Object)e)).getName();
        }
        return null;
    }

    public static <E extends Enum<E>> List<String> getNameByCode(Class<E> enumClass, List<Integer> codes) {
        ArrayList<String> names = new ArrayList<String>();
        if (CollectionUtils.isEmpty(codes)) {
            return names;
        }
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            if (!codes.contains(((BaseEnum)((Object)e)).getCode())) continue;
            names.add(((BaseEnum)((Object)e)).getName());
        }
        return names;
    }

    public static enum UserConstellationEnum implements BaseEnum
    {
        ARIES(0, "\u767d\u7f8a\u5ea7", "\u767d\u7f8a\u5ea7", true, true, date -> UserConstellationEnum.isBetween(date, 3, 21, 4, 19)),
        TAURUS(1, "\u91d1\u725b\u5ea7", "\u91d1\u725b\u5ea7", true, true, date -> UserConstellationEnum.isBetween(date, 4, 20, 5, 20)),
        GEMINI(2, "\u53cc\u5b50\u5ea7", "\u53cc\u5b50\u5ea7", true, true, date -> UserConstellationEnum.isBetween(date, 5, 21, 6, 20)),
        CANCER(3, "\u5de8\u87f9\u5ea7", "\u5de8\u87f9\u5ea7", true, true, date -> UserConstellationEnum.isBetween(date, 6, 21, 7, 22)),
        LEO(4, "\u72ee\u5b50\u5ea7", "\u72ee\u5b50\u5ea7", true, true, date -> UserConstellationEnum.isBetween(date, 7, 23, 8, 22)),
        VIRGO(5, "\u5904\u5973\u5ea7", "\u5904\u5973\u5ea7", true, true, date -> UserConstellationEnum.isBetween(date, 8, 23, 9, 22)),
        LIBRA(6, "\u5929\u79e4\u5ea7", "\u5929\u79e4\u5ea7", true, true, date -> UserConstellationEnum.isBetween(date, 9, 23, 10, 23)),
        SCORPIO(7, "\u5929\u874e\u5ea7", "\u5929\u874e\u5ea7", true, true, date -> UserConstellationEnum.isBetween(date, 10, 24, 11, 22)),
        SAGITTARIUS(8, "\u5c04\u624b\u5ea7", "\u5c04\u624b\u5ea7", true, true, date -> UserConstellationEnum.isBetween(date, 11, 23, 12, 21)),
        CAPRICORN(9, "\u6469\u7faf\u5ea7", "\u6469\u7faf\u5ea7", true, true, date -> UserConstellationEnum.isBetween(date, 12, 22, 1, 19)),
        AQUARIUS(10, "\u6c34\u74f6\u5ea7", "\u6c34\u74f6\u5ea7", true, true, date -> UserConstellationEnum.isBetween(date, 1, 20, 2, 18)),
        PISCES(11, "\u53cc\u9c7c\u5ea7", "\u53cc\u9c7c\u5ea7", true, true, date -> UserConstellationEnum.isBetween(date, 2, 19, 3, 20));

        private final Integer code;
        private final String name;
        private final String name2;
        private final Boolean displayName;
        private final Boolean displayName2;
        private final Function<LocalDate, Boolean> validator;

        public static UserConstellationEnum getByBirthday(LocalDate date) {
            for (UserConstellationEnum userConstellationEnum : UserConstellationEnum.values()) {
                if (!userConstellationEnum.validator.apply(date).booleanValue()) continue;
                return userConstellationEnum;
            }
            return null;
        }

        public static UserConstellationEnum getByCode(Integer code) {
            if (code == null) {
                return null;
            }
            for (UserConstellationEnum userConstellationEnum : UserConstellationEnum.values()) {
                if (!userConstellationEnum.getCode().equals(code)) continue;
                return userConstellationEnum;
            }
            return null;
        }

        private static boolean isBetween(LocalDate date, int startMonth, int startDay, int endMonth, int endDay) {
            LocalDate start = LocalDate.of(date.getYear(), startMonth, startDay);
            LocalDate end = LocalDate.of(date.getYear(), endMonth, endDay);
            if (end.isBefore(start)) {
                end = end.plusYears(1L);
            }
            if (date.isBefore(start) && end.getMonthValue() == 1) {
                start = start.minusYears(1L);
                end = end.minusYears(1L);
            }
            return !date.isBefore(start) && !date.isAfter(end);
        }

        private UserConstellationEnum(Integer code, String name, String name2, Boolean displayName, Boolean displayName2, Function<LocalDate, Boolean> validator) {
            this.code = code;
            this.name = name;
            this.name2 = name2;
            this.displayName = displayName;
            this.displayName2 = displayName2;
            this.validator = validator;
        }

        @Override
        public Integer getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getName2() {
            return this.name2;
        }

        @Override
        public Boolean getDisplayName() {
            return this.displayName;
        }

        @Override
        public Boolean getDisplayName2() {
            return this.displayName2;
        }

        public Function<LocalDate, Boolean> getValidator() {
            return this.validator;
        }
    }

    public static enum UserZodiacEnum implements BaseEnum
    {
        RAT(0, "\u9f20", "\u9f20", true, true),
        OX(1, "\u725b", "\u725b", true, true),
        TIGER(2, "\u864e", "\u864e", true, true),
        RABBIT(3, "\u5154", "\u5154", true, true),
        DRAGON(4, "\u9f99", "\u9f99", true, true),
        SNAKE(5, "\u86c7", "\u86c7", true, true),
        HORSE(6, "\u9a6c", "\u9a6c", true, true),
        GOAT(7, "\u7f8a", "\u7f8a", true, true),
        MONKEY(8, "\u7334", "\u7334", true, true),
        ROOSTER(9, "\u9e21", "\u9e21", true, true),
        DOG(10, "\u72d7", "\u72d7", true, true),
        PIG(11, "\u732a", "\u732a", true, true);

        private final Integer code;
        private final String name;
        private final String name2;
        private final Boolean displayName;
        private final Boolean displayName2;

        public static UserZodiacEnum getByBirthday(LocalDate birthday) {
            int zodiac = ((birthday.getYear() - 2020) % 12 + 12) % 12;
            return UserZodiacEnum.values()[zodiac];
        }

        private UserZodiacEnum(Integer code, String name, String name2, Boolean displayName, Boolean displayName2) {
            this.code = code;
            this.name = name;
            this.name2 = name2;
            this.displayName = displayName;
            this.displayName2 = displayName2;
        }

        @Override
        public Integer getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getName2() {
            return this.name2;
        }

        @Override
        public Boolean getDisplayName() {
            return this.displayName;
        }

        @Override
        public Boolean getDisplayName2() {
            return this.displayName2;
        }
    }

    public static enum SchoolRangeEnum implements BaseEnum
    {
        NO_LIMIT(1, "\u4e0d\u9650", "\u4e0d\u9650", false, false),
        TOP_SCHOOLS(2, "985\u3001211\u9662\u6821", "985\u3001211\u9662\u6821", true, true);

        private final Integer code;
        private final String name;
        private final String name2;
        private final Boolean displayName;
        private final Boolean displayName2;

        private SchoolRangeEnum(Integer code, String name, String name2, Boolean displayName, Boolean displayName2) {
            this.code = code;
            this.name = name;
            this.name2 = name2;
            this.displayName = displayName;
            this.displayName2 = displayName2;
        }

        @Override
        public Integer getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getName2() {
            return this.name2;
        }

        @Override
        public Boolean getDisplayName() {
            return this.displayName;
        }

        @Override
        public Boolean getDisplayName2() {
            return this.displayName2;
        }
    }

    public static enum LifeRangeEnum implements BaseEnum
    {
        NO_PREFERENCE(1, "\u65e0\u6240\u8c13", "\u65e0\u6240\u8c13", true, true),
        FAMILY_ORIENTED(2, "\u987e\u5bb6\u578b", "\u987e\u5bb6\u578b", true, true),
        CAREER_ORIENTED(4, "\u4e8b\u4e1a\u578b", "\u4e8b\u4e1a\u578b", true, true);

        private final Integer code;
        private final String name;
        private final String name2;
        private final Boolean displayName;
        private final Boolean displayName2;

        private LifeRangeEnum(Integer code, String name, String name2, Boolean displayName, Boolean displayName2) {
            this.code = code;
            this.name = name;
            this.name2 = name2;
            this.displayName = displayName;
            this.displayName2 = displayName2;
        }

        @Override
        public Integer getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getName2() {
            return this.name2;
        }

        @Override
        public Boolean getDisplayName() {
            return this.displayName;
        }

        @Override
        public Boolean getDisplayName2() {
            return this.displayName2;
        }
    }

    public static enum JobRangeEnum implements BaseEnum
    {
        NO_PREFERENCE(1, "\u65e0\u6240\u8c13", "\u65e0\u6240\u8c13", true, true),
        STABLE_JOB(2, "\u7a33\u5b9a\u5de5\u4f5c", "\u7a33\u5b9a\u5de5\u4f5c", true, true),
        ENTREPRENEURSHIP(4, "\u521b\u4e1a\u7ecf\u5546", "\u521b\u4e1a\u7ecf\u5546", true, true);

        private final Integer code;
        private final String name;
        private final String name2;
        private final Boolean displayName;
        private final Boolean displayName2;

        private JobRangeEnum(Integer code, String name, String name2, Boolean displayName, Boolean displayName2) {
            this.code = code;
            this.name = name;
            this.name2 = name2;
            this.displayName = displayName;
            this.displayName2 = displayName2;
        }

        @Override
        public Integer getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getName2() {
            return this.name2;
        }

        @Override
        public Boolean getDisplayName() {
            return this.displayName;
        }

        @Override
        public Boolean getDisplayName2() {
            return this.displayName2;
        }
    }

    public static enum IndustryRangeEnum implements BaseEnum
    {
        NO_PREFERENCE(1, "\u65e0\u6240\u8c13", "\u65e0\u6240\u8c13", true, true),
        SAME_INDUSTRY(2, "\u540c\u884c", "\u540c\u884c", true, true),
        DIFFERENT_INDUSTRY(4, "\u975e\u540c\u884c", "\u975e\u540c\u884c", true, true);

        private final Integer code;
        private final String name;
        private final String name2;
        private final Boolean displayName;
        private final Boolean displayName2;

        private IndustryRangeEnum(Integer code, String name, String name2, Boolean displayName, Boolean displayName2) {
            this.code = code;
            this.name = name;
            this.name2 = name2;
            this.displayName = displayName;
            this.displayName2 = displayName2;
        }

        @Override
        public Integer getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getName2() {
            return this.name2;
        }

        @Override
        public Boolean getDisplayName() {
            return this.displayName;
        }

        @Override
        public Boolean getDisplayName2() {
            return this.displayName2;
        }
    }

    public static enum CarEnum implements BaseEnum
    {
        NO_PREFERENCE(1, "\u65e0\u6240\u8c13", "\u65e0\u6240\u8c13", false, true),
        HAS_CAR(2, "\u5df2\u8d2d\u8f66", "\u5e0c\u671b\u5bf9\u65b9\u6709\u8f66", true, true),
        NO_CAR(4, "\u6682\u65e0", "\u63a5\u53d7\u5bf9\u65b9\u6ca1\u6709\u8f66", true, true);

        private final Integer code;
        private final String name;
        private final String name2;
        private final Boolean displayName;
        private final Boolean displayName2;

        private CarEnum(Integer code, String name, String name2, Boolean displayName, Boolean displayName2) {
            this.code = code;
            this.name = name;
            this.name2 = name2;
            this.displayName = displayName;
            this.displayName2 = displayName2;
        }

        @Override
        public Integer getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getName2() {
            return this.name2;
        }

        @Override
        public Boolean getDisplayName() {
            return this.displayName;
        }

        @Override
        public Boolean getDisplayName2() {
            return this.displayName2;
        }
    }

    public static enum HouseEnum implements BaseEnum
    {
        NO_PREFERENCE(1, "\u65e0\u6240\u8c13", "\u65e0\u6240\u8c13", false, true),
        HAS_HOUSE(2, "\u5df2\u8d2d\u623f", "\u5e0c\u671b\u5bf9\u65b9\u6709\u623f", true, true),
        NO_HOUSE(4, "\u6682\u65e0", "\u63a5\u53d7\u5bf9\u65b9\u6ca1\u6709\u623f", true, true);

        private final Integer code;
        private final String name;
        private final String name2;
        private final Boolean displayName;
        private final Boolean displayName2;

        private HouseEnum(Integer code, String name, String name2, Boolean displayName, Boolean displayName2) {
            this.code = code;
            this.name = name;
            this.name2 = name2;
            this.displayName = displayName;
            this.displayName2 = displayName2;
        }

        @Override
        public Integer getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getName2() {
            return this.name2;
        }

        @Override
        public Boolean getDisplayName() {
            return this.displayName;
        }

        @Override
        public Boolean getDisplayName2() {
            return this.displayName2;
        }
    }

    public static enum SmokeStatusEnum implements BaseEnum
    {
        NO_PREFERENCE(1, "\u65e0\u6240\u8c13", "\u65e0\u6240\u8c13/\u4e0d\u4ecb\u610f", false, true),
        OCCASIONAL(2, "\u5076\u5c14\u62bd\u70df", "\u53ef\u63a5\u53d7\u5076\u5c14\u62bd\u70df", true, true),
        REGULAR(4, "\u62bd\u70df", "\u53ef\u63a5\u53d7\u62bd\u70df", true, true),
        NON_SMOKER(8, "\u4e0d\u62bd\u70df", "\u4e0d\u63a5\u53d7\u62bd\u70df", true, true);

        private final Integer code;
        private final String name;
        private final String name2;
        private final Boolean displayName;
        private final Boolean displayName2;

        private SmokeStatusEnum(Integer code, String name, String name2, Boolean displayName, Boolean displayName2) {
            this.code = code;
            this.name = name;
            this.name2 = name2;
            this.displayName = displayName;
            this.displayName2 = displayName2;
        }

        @Override
        public Integer getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getName2() {
            return this.name2;
        }

        @Override
        public Boolean getDisplayName() {
            return this.displayName;
        }

        @Override
        public Boolean getDisplayName2() {
            return this.displayName2;
        }
    }

    public static enum CertTypeEnum implements BaseEnum
    {
        REAL_PEOPLE(1, "\u5b9e\u540d\u8ba4\u8bc1", "\u5b9e\u540d\u8ba4\u8bc1", true, true),
        EDU(2, "\u5b66\u5386\u8ba4\u8bc1", "\u5b66\u5386\u8ba4\u8bc1", true, true),
        MARRIED(4, "\u5a5a\u59fb\u8ba4\u8bc1", "\u5a5a\u59fb\u8ba4\u8bc1", true, true),
        HOUSE(8, "\u623f\u5b50\u8ba4\u8bc1", "\u623f\u5b50\u8ba4\u8bc1", true, true),
        CAR(16, "\u8f66\u8ba4\u8bc1", "\u8f66\u8ba4\u8bc1", true, true);

        private final Integer code;
        private final String name;
        private final String name2;
        private final Boolean displayName;
        private final Boolean displayName2;

        public static CertTypeEnum getCertType(Integer code) {
            if (code == null) {
                return null;
            }
            for (CertTypeEnum certTypeEnum : CertTypeEnum.values()) {
                if (!certTypeEnum.getCode().equals(code)) continue;
                return certTypeEnum;
            }
            return null;
        }

        public static List<Integer> getNeededCertTypes() {
            return Lists.newArrayList((Object[])new Integer[]{REAL_PEOPLE.getCode(), EDU.getCode(), MARRIED.getCode(), CAR.getCode()});
        }

        private CertTypeEnum(Integer code, String name, String name2, Boolean displayName, Boolean displayName2) {
            this.code = code;
            this.name = name;
            this.name2 = name2;
            this.displayName = displayName;
            this.displayName2 = displayName2;
        }

        @Override
        public Integer getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getName2() {
            return this.name2;
        }

        @Override
        public Boolean getDisplayName() {
            return this.displayName;
        }

        @Override
        public Boolean getDisplayName2() {
            return this.displayName2;
        }
    }

    public static enum TattooStatusEnum implements BaseEnum
    {
        NO_PREFERENCE(1, "\u65e0\u6240\u8c13", "\u65e0\u6240\u8c13/\u4e0d\u4ecb\u610f", false, true),
        SMALL_OR_HIDDEN(2, "\u5c0f\u9762\u79ef/\u9690\u85cf\u90e8\u4f4d\u7eb9\u8eab", "\u53ef\u63a5\u53d7\u5c0f\u9762\u79ef/\u9690\u85cf\u90e8\u4f4d\u7eb9\u8eab", true, true),
        LARGE_OR_VISIBLE(4, "\u5927\u9762\u79ef/\u660e\u663e\u90e8\u4f4d\u7eb9\u8eab", "\u53ef\u63a5\u53d7\u5927\u9762\u79ef/\u660e\u663e\u90e8\u4f4d\u7eb9\u8eab", true, true),
        NO_TATTOO(8, "\u6ca1\u7eb9\u8eab", "\u4e0d\u63a5\u53d7\u4efb\u4f55\u7eb9\u8eab", true, true);

        private final Integer code;
        private final String name;
        private final String name2;
        private final Boolean displayName;
        private final Boolean displayName2;

        private TattooStatusEnum(Integer code, String name, String name2, Boolean displayName, Boolean displayName2) {
            this.code = code;
            this.name = name;
            this.name2 = name2;
            this.displayName = displayName;
            this.displayName2 = displayName2;
        }

        @Override
        public Integer getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getName2() {
            return this.name2;
        }

        @Override
        public Boolean getDisplayName() {
            return this.displayName;
        }

        @Override
        public Boolean getDisplayName2() {
            return this.displayName2;
        }
    }

    public static enum LoveGoalEnum implements BaseEnum
    {
        UNDECIDED(1, "\u6ca1\u8003\u8651\u6e05\u695a", "\u6ca1\u8003\u8651\u6e05\u695a", true, true),
        WANT_MARRIAGE_SOON(2, "\u77ed\u671f\u5185\u60f3\u7ed3\u5a5a", "\u77ed\u671f\u5185\u60f3\u7ed3\u5a5a", true, true),
        SERIOUS_DATING(4, "\u5148\u8ba4\u771f\u8c08\u573a\u604b\u7231", "\u5148\u8ba4\u771f\u8c08\u573a\u604b\u7231", true, true),
        DATING_THEN_MAY_MARRY(8, "\u5148\u8ba4\u771f\u8c08\u573a\u604b\u7231\uff0c\u5408\u9002\u53ef\u4ee5\u7ed3\u5a5a", "\u5148\u8ba4\u771f\u8c08\u573a\u604b\u7231\uff0c\u5408\u9002\u53ef\u4ee5\u7ed3\u5a5a", true, true);

        private final Integer code;
        private final String name;
        private final String name2;
        private final Boolean displayName;
        private final Boolean displayName2;

        private LoveGoalEnum(Integer code, String name, String name2, Boolean displayName, Boolean displayName2) {
            this.code = code;
            this.name = name;
            this.name2 = name2;
            this.displayName = displayName;
            this.displayName2 = displayName2;
        }

        @Override
        public Integer getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getName2() {
            return this.name2;
        }

        @Override
        public Boolean getDisplayName() {
            return this.displayName;
        }

        @Override
        public Boolean getDisplayName2() {
            return this.displayName2;
        }
    }

    public static enum ChildrenStatusEnum implements BaseEnum
    {
        NO_PREFERENCE(1, "\u65e0", "\u5176\u4ed6", true, true),
        NO_CHILDREN(2, "\u65e0\u5b50\u5973", "\u65e0\u5b50\u5973", false, true),
        ONE_SON(4, "\u6709\u4e00\u4e2a\u513f\u5b50", "\u4e00\u4e2a\u513f\u5b50", true, true),
        ONE_DAUGHTER(8, "\u6709\u4e00\u4e2a\u5973\u513f", "\u4e00\u4e2a\u5973\u5973", true, true),
        ONE_SON_ONE_DAUGHTER(16, "\u6709\u4e00\u5b50\u4e00\u5973", "\u4e00\u513f\u4e00\u5973", true, true),
        TWO_SONS(32, "\u6709\u4e24\u4e2a\u513f\u5b50", "\u4e24\u4e2a\u513f\u5b50", true, true),
        TWO_DAUGHTERS(64, "\u6709\u4e24\u4e2a\u5973\u513f", "\u4e24\u4e2a\u5973\u513f", true, true),
        MORE_THAN_TWO(128, "\u6709\u4e24\u4e2a\u4ee5\u4e0a\u5b50\u5973", "\u4e24\u4e2a\u4ee5\u4e0a\u5b50\u5973", true, true);

        private final Integer code;
        private final String name;
        private final String name2;
        private final Boolean displayName;
        private final Boolean displayName2;

        private ChildrenStatusEnum(Integer code, String name, String name2, Boolean displayName, Boolean displayName2) {
            this.code = code;
            this.name = name;
            this.name2 = name2;
            this.displayName = displayName;
            this.displayName2 = displayName2;
        }

        @Override
        public Integer getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getName2() {
            return this.name2;
        }

        @Override
        public Boolean getDisplayName() {
            return this.displayName;
        }

        @Override
        public Boolean getDisplayName2() {
            return this.displayName2;
        }
    }

    public static enum MarriageStatusEnum implements BaseEnum
    {
        NO_PREFERENCE(1, "\u4e0d\u9650", "\u4e0d\u9650", false, true),
        SINGLE(2, "\u672a\u5a5a", "\u672a\u5a5a", true, true),
        DIVORCED(4, "\u79bb\u5f02", "\u79bb\u5f02", true, true),
        WIDOWED(8, "\u4e27\u5076", "\u4e27\u5076", true, true);

        private final Integer code;
        private final String name;
        private final String name2;
        private final Boolean displayName;
        private final Boolean displayName2;

        private MarriageStatusEnum(Integer code, String name, String name2, Boolean displayName, Boolean displayName2) {
            this.code = code;
            this.name = name;
            this.name2 = name2;
            this.displayName = displayName;
            this.displayName2 = displayName2;
        }

        @Override
        public Integer getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getName2() {
            return this.name2;
        }

        @Override
        public Boolean getDisplayName() {
            return this.displayName;
        }

        @Override
        public Boolean getDisplayName2() {
            return this.displayName2;
        }
    }

    public static enum MarriageChildrenRelaxStatusEnum implements BaseEnum
    {
        DIVORCED_NO_CHILDREN(4, "\u79bb\u5f02\u65e0\u5b50\u5973", "\u79bb\u5f02\u65e0\u5b50\u5973", true, true),
        DIVORCED_ONE_DAUGHTER(8, "\u79bb\u5f02\u6709\u4e00\u4e2a\u5973\u513f", "\u79bb\u5f02\u6709\u4e00\u4e2a\u5973\u513f", true, true),
        DIVORCED_ONE_SON(16, "\u79bb\u5f02\u6709\u4e00\u4e2a\u513f\u5b50", "\u79bb\u5f02\u6709\u4e00\u4e2a\u513f\u5b50", true, true),
        DIVORCED_MORE_CHILDREN(32, "\u79bb\u5f02\u6709\u591a\u4e2a\u5b50\u5973", "\u79bb\u5f02\u6709\u591a\u4e2a\u5b50\u5973", true, true),
        WIDOWED_NO_CHILDREN(64, "\u4e27\u5076\u65e0\u5b50\u5973", "\u4e27\u5076\u65e0\u5b50\u5973", true, true),
        WIDOWED_MORE_CHILDREN(128, "\u4e27\u5076\u6709\u5b50\u5973", "\u4e27\u5076\u6709\u5b50\u5973", true, true);

        private final Integer code;
        private final String name;
        private final String name2;
        private final Boolean displayName;
        private final Boolean displayName2;

        private MarriageChildrenRelaxStatusEnum(Integer code, String name, String name2, Boolean displayName, Boolean displayName2) {
            this.code = code;
            this.name = name;
            this.name2 = name2;
            this.displayName = displayName;
            this.displayName2 = displayName2;
        }

        @Override
        public Integer getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getName2() {
            return this.name2;
        }

        @Override
        public Boolean getDisplayName() {
            return this.displayName;
        }

        @Override
        public Boolean getDisplayName2() {
            return this.displayName2;
        }
    }

    public static enum MarriageChildrenStatusEnum implements BaseEnum
    {
        SINGLE(2, "\u672a\u5a5a", "\u672a\u5a5a", true, true),
        DIVORCED_NO_CHILDREN(4, "\u79bb\u5f02\u65e0\u5b50\u5973", "\u79bb\u5f02\u65e0\u5b50\u5973", true, true),
        DIVORCED_ONE_DAUGHTER(8, "\u79bb\u5f02\u6709\u4e00\u4e2a\u5973\u513f", "\u79bb\u5f02\u6709\u4e00\u4e2a\u5973\u513f", true, true),
        DIVORCED_ONE_SON(16, "\u79bb\u5f02\u6709\u4e00\u4e2a\u513f\u5b50", "\u79bb\u5f02\u6709\u4e00\u4e2a\u513f\u5b50", true, true),
        DIVORCED_MORE_CHILDREN(32, "\u79bb\u5f02\u6709\u591a\u4e2a\u5b50\u5973", "\u79bb\u5f02\u6709\u591a\u4e2a\u5b50\u5973", true, true),
        WIDOWED_NO_CHILDREN(64, "\u4e27\u5076\u65e0\u5b50\u5973", "\u4e27\u5076\u65e0\u5b50\u5973", true, true),
        WIDOWED_MORE_CHILDREN(128, "\u4e27\u5076\u6709\u5b50\u5973", "\u4e27\u5076\u6709\u5b50\u5973", true, true);

        private final Integer code;
        private final String name;
        private final String name2;
        private final Boolean displayName;
        private final Boolean displayName2;

        private MarriageChildrenStatusEnum(Integer code, String name, String name2, Boolean displayName, Boolean displayName2) {
            this.code = code;
            this.name = name;
            this.name2 = name2;
            this.displayName = displayName;
            this.displayName2 = displayName2;
        }

        @Override
        public Integer getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getName2() {
            return this.name2;
        }

        @Override
        public Boolean getDisplayName() {
            return this.displayName;
        }

        @Override
        public Boolean getDisplayName2() {
            return this.displayName2;
        }
    }

    public static enum EduHighestEnum implements BaseEnum
    {
        NO_PREFERENCE(1, "\u5176\u4ed6", "\u5176\u4ed6", false, false),
        HIGH_SCHOOL_OR_BELOW(2, "\u9ad8\u4e2d\u53ca\u4ee5\u4e0b", "\u9ad8\u4e2d\u53ca\u4ee5\u4e0b", true, true),
        JUNIOR_COLLEGE(4, "\u5927\u4e13", "\u5927\u4e13", true, true),
        BACHELOR(8, "\u672c\u79d1", "\u672c\u79d1", true, true),
        MASTER(16, "\u7855\u58eb", "\u7855\u58eb", true, true),
        DOCTOR(32, "\u535a\u58eb", "\u535a\u58eb", true, true);

        private final Integer code;
        private final String name;
        private final String name2;
        private final Boolean displayName;
        private final Boolean displayName2;

        private EduHighestEnum(Integer code, String name, String name2, Boolean displayName, Boolean displayName2) {
            this.code = code;
            this.name = name;
            this.name2 = name2;
            this.displayName = displayName;
            this.displayName2 = displayName2;
        }

        @Override
        public Integer getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getName2() {
            return this.name2;
        }

        @Override
        public Boolean getDisplayName() {
            return this.displayName;
        }

        @Override
        public Boolean getDisplayName2() {
            return this.displayName2;
        }
    }

    public static enum YearRevenueEnum implements BaseEnum
    {
        NO_PREFERENCE(1, "\u5176\u4ed6", "\u4e0d\u4ecb\u610f", false, true),
        BELOW_5K(2, "5\u4e07\u4ee5\u4e0b", "5\u4e07\u4ee5\u4e0b", true, true),
        FROM_5K_TO_10K(4, "5-10\u4e07", "5-10\u4e07", true, true),
        FROM_10K_TO_20K(8, "10-20\u4e07", "10-20\u4e07", true, true),
        FROM_20K_TO_30K(16, "20-30\u4e07", "20-30\u4e07", true, true),
        FROM_30K_TO_40K(32, "30-40\u4e07", "30-40\u4e07", true, true),
        FROM_40K_TO_50K(64, "40-50\u4e07", "40-50\u4e07", true, true),
        FROM_50K_TO_100K(128, "50-100\u4e07", "50-100\u4e07", true, true),
        ABOVE_100K(256, "100\u4e07\u4ee5\u4e0a", "100\u4e07\u4ee5\u4e0a", true, true);

        private final Integer code;
        private final String name;
        private final String name2;
        private final Boolean displayName;
        private final Boolean displayName2;

        private YearRevenueEnum(Integer code, String name, String name2, Boolean displayName, Boolean displayName2) {
            this.code = code;
            this.name = name;
            this.name2 = name2;
            this.displayName = displayName;
            this.displayName2 = displayName2;
        }

        @Override
        public Integer getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getName2() {
            return this.name2;
        }

        @Override
        public Boolean getDisplayName() {
            return this.displayName;
        }

        @Override
        public Boolean getDisplayName2() {
            return this.displayName2;
        }
    }

    public static enum BodyShapeEnum implements BaseEnum
    {
        SLIM_ELEGANT(1, "\u7ea4\u7626\u82d7\u6761\u578b", "\u7ea4\u7626\u82d7\u6761\u578b", true, true),
        FIT_DYNAMIC(2, "\u5065\u7f8e\u6d3b\u529b\u578b", "\u5065\u7f8e\u6d3b\u529b\u578b", true, true),
        BALANCED_STANDARD(4, "\u5300\u79f0\u6807\u51c6\u578b", "\u5300\u79f0\u6807\u51c6\u578b", true, true),
        CURVY_HOURGLASS(8, "\u66f2\u7ebf\u6c99\u6f0f\u578b", "\u66f2\u7ebf\u6c99\u6f0f\u578b", true, true),
        PLUMP_FULL_FIGURE(16, "\u4e30\u6ee1\u4e30\u8174\u578b", "\u4e30\u6ee1\u4e30\u8174\u578b", true, true),
        LEAN_SLIM(1024, "\u7ea4\u7626\u6e05\u7626\u578b", "\u7ea4\u7626\u6e05\u7626\u578b", true, true),
        SPORTY_FIT(2048, "\u8fd0\u52a8\u5065\u7f8e\u578b", "\u8fd0\u52a8\u5065\u7f8e\u578b", true, true),
        MUSCULAR_BUILD(4096, "\u808c\u8089\u5065\u7855\u578b", "\u808c\u8089\u5065\u7855\u578b", true, true),
        BALANCED_STANDARD_AGAIN(8192, "\u5300\u79f0\u6807\u51c6\u578b", "\u5300\u79f0\u6807\u51c6\u578b", true, true),
        STRONG_STURDY(16384, "\u58ee\u58eb\u6566\u539a\u578b", "\u58ee\u58eb\u6566\u539a\u578b", true, true);

        private final Integer code;
        private final String name;
        private final String name2;
        private final Boolean displayName;
        private final Boolean displayName2;

        private BodyShapeEnum(Integer code, String name, String name2, Boolean displayName, Boolean displayName2) {
            this.code = code;
            this.name = name;
            this.name2 = name2;
            this.displayName = displayName;
            this.displayName2 = displayName2;
        }

        @Override
        public Integer getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getName2() {
            return this.name2;
        }

        @Override
        public Boolean getDisplayName() {
            return this.displayName;
        }

        @Override
        public Boolean getDisplayName2() {
            return this.displayName2;
        }
    }

    public static enum EnumType {
        YEAR_REVENUE(1, YearRevenueEnum.values()),
        EDU_HIGHEST(2, EduHighestEnum.values()),
        MARRIAGE(3, MarriageStatusEnum.values()),
        CHILDREN(4, ChildrenStatusEnum.values()),
        LOVE_GOAL(5, LoveGoalEnum.values()),
        TATTOO_STATUS(6, TattooStatusEnum.values()),
        SMOKE_STATUS(7, SmokeStatusEnum.values()),
        HOUSE(8, HouseEnum.values()),
        CAR(9, CarEnum.values()),
        ZODIAC(10, UserZodiacEnum.values()),
        CONSTELLATION(11, UserConstellationEnum.values()),
        INDUSTRY(12, IndustryRangeEnum.values()),
        JOB(13, JobRangeEnum.values()),
        LIFE(14, LifeRangeEnum.values()),
        SCHOOL(15, SchoolRangeEnum.values()),
        CERT_TYPE(16, CertTypeEnum.values()),
        MARRIAGE_CHILDREN(17, MarriageChildrenStatusEnum.values()),
        MARRIAGE_CHILDREN_RELAX(18, MarriageChildrenRelaxStatusEnum.values()),
        BODY_SHAPE(19, BodyShapeEnum.values());

        private final Integer type;
        private final BaseEnum[] baseEnums;

        private EnumType(Integer type, BaseEnum[] baseEnums) {
            this.type = type;
            this.baseEnums = baseEnums;
        }

        public Integer getType() {
            return this.type;
        }

        public BaseEnum[] getBaseEnums() {
            return this.baseEnums;
        }
    }

    public static interface BaseEnum {
        public Integer getCode();

        public String getName();

        public String getName2();

        public Boolean getDisplayName();

        public Boolean getDisplayName2();
    }
}

