/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.contant.UserConstants;
import com.bxm.lovelink.common.dal.entity.UserCertResult;
import com.bxm.lovelink.common.handler.AesEncDecHandler;
import com.bxm.warcar.utils.JsonHelper;
import java.io.Serializable;
import java.time.LocalDateTime;
import org.apache.commons.lang3.StringUtils;

@TableName(value="user_cert", autoResultMap=true)
public class UserCert
implements Serializable {
    public static final int size = 5;
    private static final long serialVersionUID = 1L;
    public static final Integer TYPE_REAL_NAME = UserConstants.CertTypeEnum.REAL_PEOPLE.getCode();
    public static final Integer TYPE_EDUCATION = UserConstants.CertTypeEnum.EDU.getCode();
    public static final Integer TYPE_MARRIAGE = UserConstants.CertTypeEnum.MARRIED.getCode();
    public static final Integer TYPE_HOUSE = UserConstants.CertTypeEnum.HOUSE.getCode();
    public static final Integer TYPE_CAR = UserConstants.CertTypeEnum.CAR.getCode();
    public static final Integer STATUS_WAITING = 0;
    public static final Integer STATUS_CHECKING = 1;
    public static final Integer STATUS_PASS = 2;
    public static final Integer STATUS_FAIL = -1;
    @TableId(value="id", type=IdType.AUTO)
    private Long id;
    private Long userId;
    private Integer certType;
    @TableField(typeHandler=AesEncDecHandler.class)
    private String certContent;
    private String certResult;
    private Integer certStatus;
    private LocalDateTime createTime;
    private LocalDateTime modifyTime;

    public boolean isRealName() {
        return TYPE_REAL_NAME.equals(this.certType);
    }

    public boolean isWaiting() {
        return STATUS_WAITING.equals(this.certStatus) || STATUS_CHECKING.equals(this.certStatus);
    }

    public boolean isSuccess() {
        return STATUS_PASS.equals(this.certStatus);
    }

    public boolean isSuccessWithCarNum() {
        if (STATUS_PASS.equals(this.certStatus) && TYPE_CAR.equals(this.certType) && StringUtils.isNotBlank((CharSequence)this.certResult)) {
            return ((UserCertResult)JsonHelper.convert((String)this.certResult, UserCertResult.class)).getCarNum() > 0;
        }
        return STATUS_PASS.equals(this.certStatus);
    }

    public boolean isByApi() {
        return !this.isRealName();
    }

    public boolean isUnMarried() {
        if (StringUtils.isBlank((CharSequence)this.certResult)) {
            return false;
        }
        return STATUS_PASS.equals(this.certStatus) && TYPE_MARRIAGE.equals(this.certType) && ((UserCertResult)JsonHelper.convert((String)this.certResult, UserCertResult.class)).getStatus() == 0;
    }

    public Integer getEduHighest() {
        if (StringUtils.isBlank((CharSequence)this.certResult)) {
            return null;
        }
        UserCertResult result = (UserCertResult)JsonHelper.convert((String)this.certResult, UserCertResult.class);
        String eduLevel = result.getEducationLevel();
        return Constants.mapEducationLevel(eduLevel);
    }

    public Long getId() {
        return this.id;
    }

    public Long getUserId() {
        return this.userId;
    }

    public Integer getCertType() {
        return this.certType;
    }

    public String getCertContent() {
        return this.certContent;
    }

    public String getCertResult() {
        return this.certResult;
    }

    public Integer getCertStatus() {
        return this.certStatus;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public LocalDateTime getModifyTime() {
        return this.modifyTime;
    }

    public UserCert setId(Long id) {
        this.id = id;
        return this;
    }

    public UserCert setUserId(Long userId) {
        this.userId = userId;
        return this;
    }

    public UserCert setCertType(Integer certType) {
        this.certType = certType;
        return this;
    }

    public UserCert setCertContent(String certContent) {
        this.certContent = certContent;
        return this;
    }

    public UserCert setCertResult(String certResult) {
        this.certResult = certResult;
        return this;
    }

    public UserCert setCertStatus(Integer certStatus) {
        this.certStatus = certStatus;
        return this;
    }

    public UserCert setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
        return this;
    }

    public UserCert setModifyTime(LocalDateTime modifyTime) {
        this.modifyTime = modifyTime;
        return this;
    }

    public String toString() {
        return "UserCert(id=" + this.getId() + ", userId=" + this.getUserId() + ", certType=" + this.getCertType() + ", certContent=" + this.getCertContent() + ", certResult=" + this.getCertResult() + ", certStatus=" + this.getCertStatus() + ", createTime=" + this.getCreateTime() + ", modifyTime=" + this.getModifyTime() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserCert)) {
            return false;
        }
        UserCert other = (UserCert)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Integer this$certType = this.getCertType();
        Integer other$certType = other.getCertType();
        if (this$certType == null ? other$certType != null : !((Object)this$certType).equals(other$certType)) {
            return false;
        }
        Integer this$certStatus = this.getCertStatus();
        Integer other$certStatus = other.getCertStatus();
        if (this$certStatus == null ? other$certStatus != null : !((Object)this$certStatus).equals(other$certStatus)) {
            return false;
        }
        String this$certContent = this.getCertContent();
        String other$certContent = other.getCertContent();
        if (this$certContent == null ? other$certContent != null : !this$certContent.equals(other$certContent)) {
            return false;
        }
        String this$certResult = this.getCertResult();
        String other$certResult = other.getCertResult();
        if (this$certResult == null ? other$certResult != null : !this$certResult.equals(other$certResult)) {
            return false;
        }
        LocalDateTime this$createTime = this.getCreateTime();
        LocalDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        LocalDateTime this$modifyTime = this.getModifyTime();
        LocalDateTime other$modifyTime = other.getModifyTime();
        return !(this$modifyTime == null ? other$modifyTime != null : !((Object)this$modifyTime).equals(other$modifyTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserCert;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Integer $certType = this.getCertType();
        result = result * 59 + ($certType == null ? 43 : ((Object)$certType).hashCode());
        Integer $certStatus = this.getCertStatus();
        result = result * 59 + ($certStatus == null ? 43 : ((Object)$certStatus).hashCode());
        String $certContent = this.getCertContent();
        result = result * 59 + ($certContent == null ? 43 : $certContent.hashCode());
        String $certResult = this.getCertResult();
        result = result * 59 + ($certResult == null ? 43 : $certResult.hashCode());
        LocalDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        LocalDateTime $modifyTime = this.getModifyTime();
        result = result * 59 + ($modifyTime == null ? 43 : ((Object)$modifyTime).hashCode());
        return result;
    }
}

