/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.entity.dao;

import com.baomidou.mybatisplus.annotation.TableField;
import com.bxm.lovelink.common.dal.entity.MeetGroup;
import com.bxm.lovelink.common.dal.entity.User;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import java.time.LocalDateTime;
import java.util.Objects;

public class MeetGroupDao
extends MeetGroup {
    private static final long serialVersionUID = 1L;
    @TableField(exist=false)
    private UserBasicInfo inviteUserBasicInfo;
    @TableField(exist=false)
    private UserBasicInfo acceptUserBasicInfo;
    @TableField(exist=false)
    private User inviteUser;
    @TableField(exist=false)
    private User acceptUser;
    @TableField(exist=false)
    private String lastMessageContent;
    @TableField(exist=false)
    private LocalDateTime lastMessageTime;

    public boolean isExpiredInInviteTimeOut() {
        LocalDateTime inviteExpireTime = this.getInviteExpireTime();
        return null != inviteExpireTime && LocalDateTime.now().isAfter(inviteExpireTime);
    }

    public UserBasicInfo getME(Long myUserId) {
        if (myUserId.equals(this.getInviteUserId())) {
            return this.inviteUserBasicInfo;
        }
        return this.acceptUserBasicInfo;
    }

    public UserBasicInfo getTA(Long myUserId) {
        if (myUserId.equals(this.getInviteUserId())) {
            return this.acceptUserBasicInfo;
        }
        return this.inviteUserBasicInfo;
    }

    public void updateMeetResultForMe(Long userId, Integer meetResult, String desc) {
        if (Objects.equals(userId, this.getInviteUserId())) {
            this.setMeetInviteUserResult(meetResult);
            this.setMeetInviteUserResultDesc(desc);
        } else if (Objects.equals(userId, this.getAcceptUserId())) {
            this.setMeetAcceptUserResult(meetResult);
            this.setMeetAcceptUserResultDesc(desc);
        }
    }

    public UserBasicInfo getInviteUserBasicInfo() {
        return this.inviteUserBasicInfo;
    }

    public UserBasicInfo getAcceptUserBasicInfo() {
        return this.acceptUserBasicInfo;
    }

    public User getInviteUser() {
        return this.inviteUser;
    }

    public User getAcceptUser() {
        return this.acceptUser;
    }

    public String getLastMessageContent() {
        return this.lastMessageContent;
    }

    public LocalDateTime getLastMessageTime() {
        return this.lastMessageTime;
    }

    public MeetGroupDao setInviteUserBasicInfo(UserBasicInfo inviteUserBasicInfo) {
        this.inviteUserBasicInfo = inviteUserBasicInfo;
        return this;
    }

    public MeetGroupDao setAcceptUserBasicInfo(UserBasicInfo acceptUserBasicInfo) {
        this.acceptUserBasicInfo = acceptUserBasicInfo;
        return this;
    }

    public MeetGroupDao setInviteUser(User inviteUser) {
        this.inviteUser = inviteUser;
        return this;
    }

    public MeetGroupDao setAcceptUser(User acceptUser) {
        this.acceptUser = acceptUser;
        return this;
    }

    public MeetGroupDao setLastMessageContent(String lastMessageContent) {
        this.lastMessageContent = lastMessageContent;
        return this;
    }

    public MeetGroupDao setLastMessageTime(LocalDateTime lastMessageTime) {
        this.lastMessageTime = lastMessageTime;
        return this;
    }

    @Override
    public String toString() {
        return "MeetGroupDao(inviteUserBasicInfo=" + this.getInviteUserBasicInfo() + ", acceptUserBasicInfo=" + this.getAcceptUserBasicInfo() + ", inviteUser=" + this.getInviteUser() + ", acceptUser=" + this.getAcceptUser() + ", lastMessageContent=" + this.getLastMessageContent() + ", lastMessageTime=" + this.getLastMessageTime() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MeetGroupDao)) {
            return false;
        }
        MeetGroupDao other = (MeetGroupDao)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UserBasicInfo this$inviteUserBasicInfo = this.getInviteUserBasicInfo();
        UserBasicInfo other$inviteUserBasicInfo = other.getInviteUserBasicInfo();
        if (this$inviteUserBasicInfo == null ? other$inviteUserBasicInfo != null : !((Object)this$inviteUserBasicInfo).equals(other$inviteUserBasicInfo)) {
            return false;
        }
        UserBasicInfo this$acceptUserBasicInfo = this.getAcceptUserBasicInfo();
        UserBasicInfo other$acceptUserBasicInfo = other.getAcceptUserBasicInfo();
        if (this$acceptUserBasicInfo == null ? other$acceptUserBasicInfo != null : !((Object)this$acceptUserBasicInfo).equals(other$acceptUserBasicInfo)) {
            return false;
        }
        User this$inviteUser = this.getInviteUser();
        User other$inviteUser = other.getInviteUser();
        if (this$inviteUser == null ? other$inviteUser != null : !((Object)this$inviteUser).equals(other$inviteUser)) {
            return false;
        }
        User this$acceptUser = this.getAcceptUser();
        User other$acceptUser = other.getAcceptUser();
        if (this$acceptUser == null ? other$acceptUser != null : !((Object)this$acceptUser).equals(other$acceptUser)) {
            return false;
        }
        String this$lastMessageContent = this.getLastMessageContent();
        String other$lastMessageContent = other.getLastMessageContent();
        if (this$lastMessageContent == null ? other$lastMessageContent != null : !this$lastMessageContent.equals(other$lastMessageContent)) {
            return false;
        }
        LocalDateTime this$lastMessageTime = this.getLastMessageTime();
        LocalDateTime other$lastMessageTime = other.getLastMessageTime();
        return !(this$lastMessageTime == null ? other$lastMessageTime != null : !((Object)this$lastMessageTime).equals(other$lastMessageTime));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MeetGroupDao;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UserBasicInfo $inviteUserBasicInfo = this.getInviteUserBasicInfo();
        result = result * 59 + ($inviteUserBasicInfo == null ? 43 : ((Object)$inviteUserBasicInfo).hashCode());
        UserBasicInfo $acceptUserBasicInfo = this.getAcceptUserBasicInfo();
        result = result * 59 + ($acceptUserBasicInfo == null ? 43 : ((Object)$acceptUserBasicInfo).hashCode());
        User $inviteUser = this.getInviteUser();
        result = result * 59 + ($inviteUser == null ? 43 : ((Object)$inviteUser).hashCode());
        User $acceptUser = this.getAcceptUser();
        result = result * 59 + ($acceptUser == null ? 43 : ((Object)$acceptUser).hashCode());
        String $lastMessageContent = this.getLastMessageContent();
        result = result * 59 + ($lastMessageContent == null ? 43 : $lastMessageContent.hashCode());
        LocalDateTime $lastMessageTime = this.getLastMessageTime();
        result = result * 59 + ($lastMessageTime == null ? 43 : ((Object)$lastMessageTime).hashCode());
        return result;
    }
}

