/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.entity.vo.user;

import com.bxm.lovelink.common.contant.UserConstants;
import com.bxm.lovelink.common.dal.entity.UserCert;
import com.bxm.lovelink.common.dal.entity.UserCertResult;
import com.bxm.lovelink.common.dal.entity.vo.user.UserBasicInfoVo;
import com.bxm.lovelink.common.dal.entity.vo.user.UserCertVo;
import com.bxm.lovelink.common.dal.entity.vo.user.UserCmsVo;
import com.bxm.lovelink.common.dal.entity.vo.user.UserLoveConditionVo;
import com.bxm.lovelink.common.dal.entity.vo.user.UserOtherInfoVo;
import com.bxm.lovelink.common.dal.entity.vo.user.UserVo;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;

public class UserCompositeVo {
    private UserVo user;
    private UserBasicInfoVo userBasicInfo;
    private UserLoveConditionVo userLoveCondition;
    private UserOtherInfoVo userOtherInfo;
    private List<UserCertVo> userCerts;
    private UserCmsVo userCms;
    private Boolean active = false;
    private Integer avatarAuditStatus;
    private Integer marriedStatus;

    public Integer getMarriedStatus() {
        if (CollectionUtils.isEmpty(this.userCerts)) {
            return null;
        }
        UserCertVo userCertVo = this.userCerts.stream().filter(userCert -> UserConstants.CertTypeEnum.MARRIED.getCode().equals(userCert.getCertType())).findFirst().orElse(null);
        if (userCertVo == null) {
            return null;
        }
        if (Objects.equals(userCertVo.getCertStatus(), UserCert.STATUS_PASS)) {
            UserCertResult certResult = userCertVo.getCertResult();
            if (certResult != null && Objects.equals(certResult.getStatus(), 1)) {
                return 1;
            }
            return null;
        }
        return 0;
    }

    public UserVo getUser() {
        return this.user;
    }

    public UserBasicInfoVo getUserBasicInfo() {
        return this.userBasicInfo;
    }

    public UserLoveConditionVo getUserLoveCondition() {
        return this.userLoveCondition;
    }

    public UserOtherInfoVo getUserOtherInfo() {
        return this.userOtherInfo;
    }

    public List<UserCertVo> getUserCerts() {
        return this.userCerts;
    }

    public UserCmsVo getUserCms() {
        return this.userCms;
    }

    public Boolean getActive() {
        return this.active;
    }

    public Integer getAvatarAuditStatus() {
        return this.avatarAuditStatus;
    }

    public UserCompositeVo setUser(UserVo user) {
        this.user = user;
        return this;
    }

    public UserCompositeVo setUserBasicInfo(UserBasicInfoVo userBasicInfo) {
        this.userBasicInfo = userBasicInfo;
        return this;
    }

    public UserCompositeVo setUserLoveCondition(UserLoveConditionVo userLoveCondition) {
        this.userLoveCondition = userLoveCondition;
        return this;
    }

    public UserCompositeVo setUserOtherInfo(UserOtherInfoVo userOtherInfo) {
        this.userOtherInfo = userOtherInfo;
        return this;
    }

    public UserCompositeVo setUserCerts(List<UserCertVo> userCerts) {
        this.userCerts = userCerts;
        return this;
    }

    public UserCompositeVo setUserCms(UserCmsVo userCms) {
        this.userCms = userCms;
        return this;
    }

    public UserCompositeVo setActive(Boolean active) {
        this.active = active;
        return this;
    }

    public UserCompositeVo setAvatarAuditStatus(Integer avatarAuditStatus) {
        this.avatarAuditStatus = avatarAuditStatus;
        return this;
    }

    public UserCompositeVo setMarriedStatus(Integer marriedStatus) {
        this.marriedStatus = marriedStatus;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserCompositeVo)) {
            return false;
        }
        UserCompositeVo other = (UserCompositeVo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Integer this$avatarAuditStatus = this.getAvatarAuditStatus();
        Integer other$avatarAuditStatus = other.getAvatarAuditStatus();
        if (this$avatarAuditStatus == null ? other$avatarAuditStatus != null : !((Object)this$avatarAuditStatus).equals(other$avatarAuditStatus)) {
            return false;
        }
        Integer this$marriedStatus = this.getMarriedStatus();
        Integer other$marriedStatus = other.getMarriedStatus();
        if (this$marriedStatus == null ? other$marriedStatus != null : !((Object)this$marriedStatus).equals(other$marriedStatus)) {
            return false;
        }
        UserVo this$user = this.getUser();
        UserVo other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        UserBasicInfoVo this$userBasicInfo = this.getUserBasicInfo();
        UserBasicInfoVo other$userBasicInfo = other.getUserBasicInfo();
        if (this$userBasicInfo == null ? other$userBasicInfo != null : !((Object)this$userBasicInfo).equals(other$userBasicInfo)) {
            return false;
        }
        UserLoveConditionVo this$userLoveCondition = this.getUserLoveCondition();
        UserLoveConditionVo other$userLoveCondition = other.getUserLoveCondition();
        if (this$userLoveCondition == null ? other$userLoveCondition != null : !((Object)this$userLoveCondition).equals(other$userLoveCondition)) {
            return false;
        }
        UserOtherInfoVo this$userOtherInfo = this.getUserOtherInfo();
        UserOtherInfoVo other$userOtherInfo = other.getUserOtherInfo();
        if (this$userOtherInfo == null ? other$userOtherInfo != null : !((Object)this$userOtherInfo).equals(other$userOtherInfo)) {
            return false;
        }
        List<UserCertVo> this$userCerts = this.getUserCerts();
        List<UserCertVo> other$userCerts = other.getUserCerts();
        if (this$userCerts == null ? other$userCerts != null : !((Object)this$userCerts).equals(other$userCerts)) {
            return false;
        }
        UserCmsVo this$userCms = this.getUserCms();
        UserCmsVo other$userCms = other.getUserCms();
        return !(this$userCms == null ? other$userCms != null : !((Object)this$userCms).equals(other$userCms));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserCompositeVo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Integer $avatarAuditStatus = this.getAvatarAuditStatus();
        result = result * 59 + ($avatarAuditStatus == null ? 43 : ((Object)$avatarAuditStatus).hashCode());
        Integer $marriedStatus = this.getMarriedStatus();
        result = result * 59 + ($marriedStatus == null ? 43 : ((Object)$marriedStatus).hashCode());
        UserVo $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        UserBasicInfoVo $userBasicInfo = this.getUserBasicInfo();
        result = result * 59 + ($userBasicInfo == null ? 43 : ((Object)$userBasicInfo).hashCode());
        UserLoveConditionVo $userLoveCondition = this.getUserLoveCondition();
        result = result * 59 + ($userLoveCondition == null ? 43 : ((Object)$userLoveCondition).hashCode());
        UserOtherInfoVo $userOtherInfo = this.getUserOtherInfo();
        result = result * 59 + ($userOtherInfo == null ? 43 : ((Object)$userOtherInfo).hashCode());
        List<UserCertVo> $userCerts = this.getUserCerts();
        result = result * 59 + ($userCerts == null ? 43 : ((Object)$userCerts).hashCode());
        UserCmsVo $userCms = this.getUserCms();
        result = result * 59 + ($userCms == null ? 43 : ((Object)$userCms).hashCode());
        return result;
    }

    public String toString() {
        return "UserCompositeVo(user=" + this.getUser() + ", userBasicInfo=" + this.getUserBasicInfo() + ", userLoveCondition=" + this.getUserLoveCondition() + ", userOtherInfo=" + this.getUserOtherInfo() + ", userCerts=" + this.getUserCerts() + ", userCms=" + this.getUserCms() + ", active=" + this.getActive() + ", avatarAuditStatus=" + this.getAvatarAuditStatus() + ", marriedStatus=" + this.getMarriedStatus() + ")";
    }
}

