/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.manager;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.chat.ByteWriter;
import com.bxm.lovelink.common.chat.ChatRequest;
import com.bxm.lovelink.common.chat.ChatService;
import com.bxm.lovelink.common.chat.CompleteConsumer;
import com.bxm.lovelink.common.chat.SimpleHandler;
import com.bxm.lovelink.common.dal.entity.ChatSession;
import com.bxm.lovelink.common.dal.entity.ChatSessionMessage;
import com.bxm.lovelink.common.dal.entity.User;
import com.bxm.lovelink.common.dal.entity.dto.chat.ApiChatDto;
import com.bxm.lovelink.common.dal.manager.parameter.ParameterBuilderFactory;
import com.bxm.lovelink.common.dal.manager.parameter.ParameterBuilderRequest;
import com.bxm.lovelink.common.dal.manager.welcome.WelcomeBuilderFactory;
import com.bxm.lovelink.common.dal.manager.welcome.WelcomeBuilderRequest;
import com.bxm.lovelink.common.dal.service.IChatSessionMessageService;
import com.bxm.lovelink.common.dal.service.IChatSessionService;
import com.bxm.lovelink.common.dal.service.IUserService;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.catalina.connector.ClientAbortException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApiChatManager {
    private static final Logger log = LoggerFactory.getLogger(ApiChatManager.class);
    private final IUserService userService;
    private final IChatSessionService chatSessionService;
    private final IChatSessionMessageService chatSessionMessageService;
    private final ChatService chatService;
    private final ParameterBuilderFactory parameterBuilderFactory;
    private final WelcomeBuilderFactory welcomeBuilderFactory;

    public ApiChatManager(IUserService userService, IChatSessionService chatSessionService, IChatSessionMessageService chatSessionMessageService, ChatService chatService, ParameterBuilderFactory parameterBuilderFactory, WelcomeBuilderFactory welcomeBuilderFactory) {
        this.userService = userService;
        this.chatSessionService = chatSessionService;
        this.chatSessionMessageService = chatSessionMessageService;
        this.chatService = chatService;
        this.parameterBuilderFactory = parameterBuilderFactory;
        this.welcomeBuilderFactory = welcomeBuilderFactory;
    }

    public List<String> buildWelcome(User user) {
        WelcomeBuilderRequest request = WelcomeBuilderRequest.builder().user(user).build();
        return this.welcomeBuilderFactory.build(request);
    }

    public ChatSession createSessionIfNecessary(Long userId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ChatSession.class).eq(ChatSession::getUserId, (Object)userId)).eq(ChatSession::getSceneType, (Object)1);
        ChatSession chatSession = (ChatSession)this.chatSessionService.getOne((Wrapper)queryWrapper);
        if (null == chatSession) {
            chatSession = new ChatSession();
            chatSession.setUserId(userId);
            this.chatSessionService.save(chatSession);
        }
        return chatSession;
    }

    public IPage<ChatSessionMessage> page(Long userId, int pageNum, int pageSize) {
        ChatSession chatSession = this.createSessionIfNecessary(userId);
        return this.chatSessionMessageService.page((IPage)new Page((long)pageNum, (long)pageSize), (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ChatSessionMessage::getSessionId, (Object)chatSession.getId())).orderByDesc(ChatSessionMessage::getId));
    }

    public void streamChat(User user, ApiChatDto apiChatDto, ByteWriter<byte[]> writeConsumer, SimpleHandler flusher, CompleteConsumer completeConsumer, BiConsumer<ClientAbortException, String> clientAbortExceptionStringBiConsumer) {
        ChatSession session = this.createSessionIfNecessary(user.getId());
        ChatSessionMessage message = apiChatDto.to().setSessionId(session.getId()).setRole("user");
        this.chatSessionMessageService.save(message);
        ChatRequest chatRequest = ChatRequest.builder().user(user).chatSession(session).chatSessionMessages(Lists.newArrayList((Object[])new ChatSessionMessage[]{message})).parameter(this.parameterBuilderFactory.build(ParameterBuilderRequest.builder().userId(user.getId()).chatSession(session).apiChatDto(apiChatDto).me(this.userService.getCompositeById(user.getId())).ta(this.userService.getCompositeById(apiChatDto.getTaUserId())).build())).writeConsumer(writeConsumer).flusher(flusher).complete(messages -> {
            ChatSessionMessage lastMessage = (ChatSessionMessage)messages.get(messages.size() - 1);
            this.chatSessionMessageService.save(lastMessage);
            log.debug("save lastMessage: {}", (Object)lastMessage);
            if (null != completeConsumer) {
                completeConsumer.accept(messages);
            }
        }).clientAbortExceptionStringBiConsumer(clientAbortExceptionStringBiConsumer).build();
        this.chatService.stream(chatRequest);
    }

    public void cancel(String conversionId) {
        this.chatService.cancel(conversionId);
    }
}

