/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.manager;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.chat.ChatRequest;
import com.bxm.lovelink.common.chat.ChatService;
import com.bxm.lovelink.common.dal.entity.ChatSession;
import com.bxm.lovelink.common.dal.entity.ChatSessionMessage;
import com.bxm.lovelink.common.dal.entity.User;
import com.bxm.lovelink.common.dal.entity.UserOtherInfo;
import com.bxm.lovelink.common.dal.entity.dao.ChatSessionDao;
import com.bxm.lovelink.common.dal.entity.dto.chat.ChatDto;
import com.bxm.lovelink.common.dal.entity.dto.chat.SessionMessageQueryDto;
import com.bxm.lovelink.common.dal.entity.vo.chat.ChatSessionMessageVo;
import com.bxm.lovelink.common.dal.entity.vo.chat.ChatSessionVo;
import com.bxm.lovelink.common.dal.mapping.ChatSessionMapping;
import com.bxm.lovelink.common.dal.mapping.ChatSessionMessageMapping;
import com.bxm.lovelink.common.dal.service.IChatSessionMessageFeedbackService;
import com.bxm.lovelink.common.dal.service.IChatSessionMessageService;
import com.bxm.lovelink.common.dal.service.IChatSessionService;
import com.bxm.lovelink.common.dal.service.IUserOtherInfoService;
import com.bxm.lovelink.constant.RedisKeys;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.google.common.collect.Lists;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ChatManager {
    private static final Logger log = LoggerFactory.getLogger(ChatManager.class);
    private final IChatSessionService chatSessionService;
    private final IChatSessionMessageService chatSessionMessageService;
    private final IChatSessionMessageFeedbackService chatSessionMessageFeedbackService;
    private final IUserOtherInfoService userOtherInfoService;
    private final ChatService chatService;
    private final Fetcher fetcher;
    private final Counter counter;
    private final Updater updater;

    public ChatSession getSession(Long userId, Long sessionId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"id", (Object)sessionId);
        queryWrapper.eq((Object)"user_id", (Object)userId);
        ChatSession chatSession = (ChatSession)this.chatSessionService.getOne((Wrapper)queryWrapper);
        if (null == chatSession) {
            throw new IllegalArgumentException("\u4f1a\u8bdd\u4e0d\u5b58\u5728");
        }
        return chatSession;
    }

    public List<ChatSessionVo> listSession(Long userId, Integer chatContactRole) {
        List<ChatSessionDao> list = this.chatSessionService.listDao((Wrapper<ChatSession>)new LambdaQueryWrapper().last(chatContactRole != null, String.format("where chat_contact_role = %s order by last_message_time desc limit 100", chatContactRole)));
        list.forEach(session -> {
            Integer unreadNum = this.countUnreadNum(userId, session.getId());
            session.setUnreadNum(Optional.ofNullable(unreadNum).orElse(0));
        });
        list.sort(Comparator.comparing(o -> o.getUnreadNum() == 0));
        return ChatSessionMapping.INSTANCE.toVosDyDao(list);
    }

    public IPage<ChatSessionMessageVo> listSessionMessage(SessionMessageQueryDto dto) {
        Page page = new Page().setCurrent((long)dto.getCurrent()).setSize((long)dto.getSize());
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ChatSessionMessage::getSessionId, (Object)dto.getSessionId())).orderByDesc(ChatSessionMessage::getId);
        IPage result = this.chatSessionMessageService.page((IPage)page, (Wrapper)query);
        return ChatSessionMessageMapping.INSTANCE.toPage((IPage<ChatSessionMessage>)result);
    }

    public Integer countUnreadNum(Long userId, Long sessionId) {
        return (Integer)this.fetcher.hfetch(RedisKeys.hashChatUnreadNum((Long)sessionId), userId.toString(), Integer.class);
    }

    public void incrUnreadNum(Long userId, Long sessionId) {
        this.counter.hincrementAndGet(RedisKeys.hashChatUnreadNum((Long)sessionId), Objects.toString(userId), RedisKeys.expireTimeOneYear.intValue());
    }

    public void readMessage(Long userId, Long sessionId) {
        this.updater.hremove(RedisKeys.hashChatUnreadNum((Long)sessionId), new String[]{userId.toString()});
    }

    public void switchChatRole(Long sessionId, Integer chatContactRole) {
        ChatSession session = (ChatSession)this.chatSessionService.getById(sessionId);
        Long userId = session.getUserId();
        this.userOtherInfoService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UserOtherInfo::getUserId, (Object)userId)).set(UserOtherInfo::getChatContactRole, (Object)chatContactRole));
    }

    public void sendMessage(ChatDto dto) {
        ChatSession chatSession = (ChatSession)this.chatSessionService.getById(dto.getSessionId());
        if (chatSession == null) {
            throw new IllegalStateException("\u4f1a\u8bdd\u4e0d\u5b58\u5728");
        }
        ChatSessionMessage message = ChatSessionMessageMapping.INSTANCE.dtoToDo(dto);
        this.chatSessionMessageService.save(message);
        Long userId = dto.getRole().equals("staff") ? chatSession.getUserId() : 0L;
        this.incrUnreadNum(message.getSessionId(), userId);
    }

    public void aiStream(ChatDto chatDto, OutputStream outputStream) {
        ChatSession session = (ChatSession)this.chatSessionService.getById(chatDto.getSessionId());
        ChatRequest chatRequest = ChatRequest.builder().user(new User().setId(0L)).chatSession(session).chatSessionMessages(Lists.newArrayList((Object[])new ChatSessionMessage[]{chatDto.to()})).writeConsumer(outputStream::write).flusher(outputStream::flush).complete(messages -> {
            ChatSessionMessage lastMessage = (ChatSessionMessage)messages.get(messages.size() - 1);
            log.debug("ai message: {}", (Object)lastMessage);
        }).clientAbortExceptionStringBiConsumer((e, s) -> IOUtils.closeQuietly((OutputStream)outputStream)).build();
        this.chatService.stream(chatRequest);
    }

    public ChatManager(IChatSessionService chatSessionService, IChatSessionMessageService chatSessionMessageService, IChatSessionMessageFeedbackService chatSessionMessageFeedbackService, IUserOtherInfoService userOtherInfoService, ChatService chatService, Fetcher fetcher, Counter counter, Updater updater) {
        this.chatSessionService = chatSessionService;
        this.chatSessionMessageService = chatSessionMessageService;
        this.chatSessionMessageFeedbackService = chatSessionMessageFeedbackService;
        this.userOtherInfoService = userOtherInfoService;
        this.chatService = chatService;
        this.fetcher = fetcher;
        this.counter = counter;
        this.updater = updater;
    }
}

