/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.manager;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.MeetGroup;
import com.bxm.lovelink.common.dal.entity.MeetGroupMessage;
import com.bxm.lovelink.common.dal.entity.User;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.entity.UserComposite;
import com.bxm.lovelink.common.dal.entity.UserMeetTicketRecord;
import com.bxm.lovelink.common.dal.entity.dao.MeetGroupDao;
import com.bxm.lovelink.common.dal.entity.dto.meet.MeetGroupAddressConfirmDto;
import com.bxm.lovelink.common.dal.entity.dto.meet.MeetGroupAddressRejectDto;
import com.bxm.lovelink.common.dal.entity.dto.meet.MeetGroupAddressSelectDto;
import com.bxm.lovelink.common.dal.entity.dto.meet.MeetGroupConfirmMeetResultDto;
import com.bxm.lovelink.common.dal.entity.dto.meet.MeetGroupMessageSendDto;
import com.bxm.lovelink.common.dal.entity.dto.meet.RequestMeetInviteDto;
import com.bxm.lovelink.common.dal.entity.dto.meet.VirtualPhoneNumberBindResult;
import com.bxm.lovelink.common.dal.entity.dto.meetticket.ReturnTicketOperateDto;
import com.bxm.lovelink.common.dal.entity.dto.meetticket.TicketOperateDto;
import com.bxm.lovelink.common.dal.service.IActivityUserMutualSelectionService;
import com.bxm.lovelink.common.dal.service.IMeetGroupMessageService;
import com.bxm.lovelink.common.dal.service.IMeetGroupService;
import com.bxm.lovelink.common.dal.service.ISensitiveService;
import com.bxm.lovelink.common.dal.service.IUserBasicInfoService;
import com.bxm.lovelink.common.dal.service.IUserMeetTicketRecordService;
import com.bxm.lovelink.common.dal.service.IUserMeetTicketService;
import com.bxm.lovelink.common.dal.service.IUserService;
import com.bxm.lovelink.common.dal.service.VirtualPhoneNumberService;
import com.bxm.lovelink.common.enums.TicketRecordTypeEnum;
import com.bxm.lovelink.common.enums.TicketReturnTypeEnum;
import com.bxm.lovelink.common.event.meet.MeetGroupAcceptedEvent;
import com.bxm.lovelink.common.event.meet.MeetGroupMeetAddrEvent;
import com.bxm.lovelink.common.event.meet.MeetGroupNewMessageEvent;
import com.bxm.lovelink.common.event.meet.MeetGroupRejectedEvent;
import com.bxm.lovelink.common.event.meet.MeetGroupRequestEvent;
import com.bxm.lovelink.common.event.meet.MeetGroupTimeoutEvent;
import com.bxm.lovelink.common.event.meet.MeetGroupWhistledEvent;
import com.bxm.lovelink.common.integration.sensitive.SensitiveTextResult;
import com.bxm.lovelink.common.push.Pusher;
import com.bxm.lovelink.common.push.factory.PushScene;
import com.bxm.lovelink.common.push.factory.PushTarget;
import com.bxm.lovelink.common.utils.UserUtils;
import com.bxm.lovelink.integration.ai.TextCompletionFacadeIntegration;
import com.bxm.warcar.integration.eventbus.EventPark;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MeetGroupManager {
    private static final Logger log = LoggerFactory.getLogger(MeetGroupManager.class);
    private final IMeetGroupService meetGroupService;
    private final IMeetGroupMessageService meetGroupMessageService;
    private final IUserService userService;
    private final IUserBasicInfoService userBasicInfoService;
    private final IUserMeetTicketService userMeetTicketService;
    private final IUserMeetTicketRecordService userMeetTicketRecordService;
    private final IActivityUserMutualSelectionService activityUserMutualSelectionService;
    private final ISensitiveService sensitiveService;
    private final VirtualPhoneNumberService virtualPhoneNumberService;
    private final EventPark eventPark;
    private final Pusher pusher;
    private final TextCompletionFacadeIntegration textCompletionFacadeIntegration;

    public MeetGroupDao findMeetGroupById(Long meetGroupId) {
        return this.meetGroupService.getDaoById(meetGroupId);
    }

    public MeetGroupDao findMeetGroupById(Long inviteUserId, Long acceptUserId) {
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().and(meetGroupQueryWrapper -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)meetGroupQueryWrapper.eq((Object)"invite_user_id", (Object)inviteUserId)).eq((Object)"accept_user_id", (Object)acceptUserId);
        })).or(meetGroupQueryWrapper -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)meetGroupQueryWrapper.eq((Object)"invite_user_id", (Object)acceptUserId)).eq((Object)"accept_user_id", (Object)inviteUserId);
        });
        return this.meetGroupService.getDaoOne((Wrapper<MeetGroup>)queryWrapper);
    }

    public String generateInviteMessage(Long acceptUserId) {
        UserComposite user = this.userService.getCompositeById(acceptUserId);
        if (user == null) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u7528\u6237");
        }
        UserBasicInfo userBasicInfo = user.getUserBasicInfo();
        String system = String.format("## \u89d2\u8272\u5b9a\u4e49\n\u4f60\u662f\u4e00\u4e2a\u4e13\u4e1a\u7684\u6587\u6848\u5927\u5e08\uff0c\u8bf7\u57fa\u4e8e\u6211\u63d0\u4f9b\u7684\u4fe1\u606f\uff0c\u5199\u4e00\u6bb5\u9080\u8bf7\u5bf9\u65b9\u89c1\u9762\u7ea6\u4f1a\u7684\u8bdd\uff0c\u4e0d\u80fd\u63d0\u53ca\u7ea6\u4f1a\u5730\u70b9\uff0c\u4e3b\u8981\u8868\u8fbe\u6b23\u8d4f\u5bf9\u65b9\u60f3\u8fdb\u4e00\u6b65\u8ba4\u8bc6\u4e00\u4e0b\u3002\n\u6839\u636e\u5bf9\u65b9\u7684\u4fe1\u606f\u6765\u5199\u51fa\u5408\u9002\u7684\u5185\u5bb9\uff0c\u8981\u6c42\u6709\u4e00\u5b9a\u6c34\u5e73\u548c\u8bd7\u610f\uff0c\u5f00\u5934\u6700\u597d\u52a0\u4e0a\u5bf9\u65b9\u7684\u79f0\u547c\uff0c\u8981\u6c42\u63a7\u5236\u572850\u4e2a\u5b57\u4ee5\u5185\u3002\n\n## \u5bf9\u65b9\u7684\u4fe1\u606f\n%s", userBasicInfo);
        String query = "\u8bf7\u5199\u4e00\u6bb5";
        return this.textCompletionFacadeIntegration.chatInviteMessage(system, query);
    }

    @Transactional(rollbackFor={Exception.class})
    public MeetGroup requestMeetInvite(Long inviteUserId, RequestMeetInviteDto requestMeetInviteDto) {
        Long acceptUserId = requestMeetInviteDto.getUserId();
        MeetGroupDao meetGroup = this.findMeetGroupById(inviteUserId, acceptUserId);
        boolean isFreeRequest = requestMeetInviteDto.isFreeRequest();
        int meetInviteNeedTicketCount = requestMeetInviteDto.getMeetInviteNeedTicketCount();
        int meetAcceptNeedTicketCount = requestMeetInviteDto.getMeetAcceptNeedTicketCount();
        if (Objects.nonNull(meetGroup)) {
            boolean accepted;
            boolean bl = accepted = meetGroup.getGroupStatus() >= Constants.MeetGroupConst.GroupStatus.ACCEPT.value();
            if (accepted) {
                if (isFreeRequest) {
                    return meetGroup;
                }
                throw new IllegalStateException("\u5f53\u524d\u89c1\u9762\u6d41\u7a0b\uff0c\u4e0d\u9700\u8981\u9080\u7ea6");
            }
            boolean timeout = Objects.equals(meetGroup.getGroupStatus(), Constants.MeetGroupConst.GroupStatus.TIMEOUT.value());
            if (!isFreeRequest && !timeout) {
                throw new IllegalStateException("\u5bf9\u65b9\u5df2\u62d2\u7edd\uff0c\u65e0\u6cd5\u91cd\u590d\u9080\u7ea6");
            }
        }
        int meetNeedTicketCount = 100;
        log.info("\u53d1\u8d77\u89c1\u9762\uff1a\u53d1\u8d77\u4eba\uff1a{}\uff0c\u53d7\u9080\u4eba\uff1a{}\uff0c\u9700\u8981\u6d88\u8017\u7684\u7ea2\u8c46\uff1a{}\uff0c\u53d1\u8d77\u4eba\u652f\u51fa\uff1a{}\uff0c\u53d7\u9080\u4eba\u652f\u51fa\uff1a{}", new Object[]{inviteUserId, acceptUserId, meetNeedTicketCount, meetInviteNeedTicketCount, meetAcceptNeedTicketCount});
        Map<Long, UserBasicInfo> userBasicInfoMap = this.getUserBasicInfoMap(inviteUserId, acceptUserId);
        UserBasicInfo inviteUser = userBasicInfoMap.get(inviteUserId);
        UserBasicInfo acceptUser = userBasicInfoMap.get(acceptUserId);
        UserBasicInfo female = this.filterFemale(userBasicInfoMap);
        if (null == female) {
            throw new IllegalStateException("sorry\uff0c\u6ca1\u6709\u5973\u751f\uff0c\u65e0\u6cd5\u7ee7\u7eed\u53d1\u8d77");
        }
        UserBasicInfo male = this.filterMale(userBasicInfoMap);
        if (null == male) {
            throw new IllegalStateException("sorry\uff0c\u6ca1\u6709\u7537\u751f\uff0c\u65e0\u6cd5\u7ee7\u7eed\u53d1\u8d77");
        }
        if (isFreeRequest) {
            boolean exists = this.activityUserMutualSelectionService.exists(male.getUserId(), female.getUserId());
            if (!exists) {
                throw new IllegalStateException("\u514d\u8d39\u9080\u7ea6\u65f6\uff0c\u5fc5\u987b\u662f\u4e92\u9009\u5173\u7cfb");
            }
            meetNeedTicketCount = 0;
        } else {
            if (UserUtils.isVip(inviteUser.getVipExpireTime())) {
                --meetNeedTicketCount;
                --meetInviteNeedTicketCount;
            }
            if (UserUtils.isVip(acceptUser.getVipExpireTime())) {
                --meetNeedTicketCount;
                --meetAcceptNeedTicketCount;
            }
        }
        log.info("\u53d1\u8d77\u89c1\u9762\u7ecf\u8fc7VIP\u8ba1\u7b97\u540e\uff1a\u53d1\u8d77\u4eba\uff1a{}\uff0c\u53d7\u9080\u4eba\uff1a{}\uff0c\u9700\u8981\u6d88\u8017\u7684\u76f8\u4eb2\u5238\uff1a{}\uff0c\u53d1\u8d77\u4eba\u652f\u51fa\uff1a{}\uff0c\u53d7\u9080\u4eba\u652f\u51fa\uff1a{}", new Object[]{inviteUserId, acceptUserId, meetNeedTicketCount, meetInviteNeedTicketCount, meetAcceptNeedTicketCount});
        if (meetNeedTicketCount - meetInviteNeedTicketCount - meetAcceptNeedTicketCount != 0) {
            throw new IllegalStateException("\u53d1\u8d77\u89c1\u9762\u7684\u76f8\u4eb2\u5238\u6570\u91cf\u65e0\u6548");
        }
        String inviteMessage = requestMeetInviteDto.getInviteMessage();
        SensitiveTextResult sensitiveTextResult = this.sensitiveService.checkText(inviteMessage);
        if (sensitiveTextResult.getHit().booleanValue()) {
            log.warn("sensitive text '{}' on message: {}", (Object)sensitiveTextResult.getText(), (Object)inviteMessage);
            throw new IllegalArgumentException("\u9080\u8bf7\u51fd\u5185\u5bb9\u4e0d\u7b26\u5408\u8981\u6c42");
        }
        MeetGroup e = new MeetGroup().setInviteUserId(inviteUserId).setAcceptUserId(acceptUserId).setInviteMessage(inviteMessage).setInviteUserReadMark(1).setAcceptUserReadMark(0).setGroupStatus(Constants.MeetGroupConst.GroupStatus.WAIT_ACCEPT.value()).setMeetNeedTicketCount(meetNeedTicketCount).setMeetInviteNeedTicketCount(meetInviteNeedTicketCount).setMeetAcceptNeedTicketCount(meetAcceptNeedTicketCount).setMeetInviteUseTicketCount(0).setMeetAcceptUseTicketCount(0).setMeetSelectAddressUserId(female.getUserId()).setMeetStatus(Constants.MeetGroupConst.MeetAddressStatus.WAIT_SELECT.value()).setInviteExpireTime(LocalDateTime.now().plusHours(48L).withSecond(0));
        if (Objects.nonNull(meetGroup)) {
            e.setId(meetGroup.getId());
        }
        this.meetGroupService.saveOrUpdate(e);
        if (meetInviteNeedTicketCount > 0) {
            TicketOperateDto dto = new TicketOperateDto().setUserId(inviteUserId).setConnectId(e.getId()).setAmount(meetInviteNeedTicketCount).setRemark(String.format("\u9080\u7ea6%s", acceptUser.getNickname()));
            this.userMeetTicketService.useTicket(dto);
            log.info("\u7528\u6237\uff1a{}\uff0c\u6d88\u8017\u4e86\uff1a{}", (Object)inviteUserId, (Object)meetInviteNeedTicketCount);
            e.setMeetInviteUseTicketCount(meetInviteNeedTicketCount);
        }
        this.meetGroupService.saveOrUpdate(e);
        PushTarget pushTarget = new PushTarget();
        pushTarget.setUserId(acceptUserId);
        pushTarget.addExtend("nickName", inviteUser.getNickname());
        this.pusher.doImmediatePush(PushScene.MEET_REQUEST, pushTarget);
        this.eventPark.post((EventObject)new MeetGroupRequestEvent(this, e, inviteUserId));
        if (isFreeRequest) {
            this.acceptMeetInvite(acceptUserId, e.getId());
        }
        return e;
    }

    public MeetGroupDao queryMeetInvite(Long userId, Long meetGroupId) {
        MeetGroupDao meetGroup = this.checkGroupInviteOrAcceptIsMine(meetGroupId, userId);
        if (meetGroup.getInviteUserId().equals(userId)) {
            meetGroup.setInviteUserReadMark(1);
        }
        if (meetGroup.getAcceptUserId().equals(userId)) {
            meetGroup.setAcceptUserReadMark(1);
        }
        this.meetGroupService.updateById(meetGroup);
        return meetGroup;
    }

    @Transactional(rollbackFor={Exception.class})
    public MeetGroupDao acceptMeetInvite(Long acceptUserId, Long meetGroupId) {
        MeetGroupDao meetGroup = this.checkGroupAcceptIsMe(meetGroupId, acceptUserId);
        if (meetGroup.getGroupStatus().intValue() != Constants.MeetGroupConst.GroupStatus.WAIT_ACCEPT.value()) {
            throw new IllegalStateException("\u89c1\u9762\u7fa4\u72b6\u6001\u65e0\u6548");
        }
        if (meetGroup.isExpiredInInviteTimeOut()) {
            throw new IllegalStateException("\u89c1\u9762\u7fa4\u9080\u8bf7\u5df2\u8fc7\u671f");
        }
        meetGroup.setGroupStatus(Constants.MeetGroupConst.GroupStatus.ACCEPT.value());
        meetGroup.setInviteUserReadMark(1);
        meetGroup.setAcceptUserReadMark(1);
        Integer meetAcceptNeedTicketCount = meetGroup.getMeetAcceptNeedTicketCount();
        if (meetAcceptNeedTicketCount > 0) {
            UserBasicInfo acceptUserBasicInfo = meetGroup.getAcceptUserBasicInfo();
            if (UserUtils.isVip(acceptUserBasicInfo.getVipExpireTime())) {
                meetAcceptNeedTicketCount = meetAcceptNeedTicketCount - 1;
                log.info("\u63a5\u53d7\u89c1\u9762\uff1a\u53d7\u9080\u4eba\u662fVIP\uff0c\u9700\u8981\u652f\u51fa\uff1a{}", (Object)meetAcceptNeedTicketCount);
            }
            log.info("\u63a5\u53d7\u89c1\u9762\uff1a\u53d7\u9080\u4eba\u9700\u8981\u652f\u51fa\uff1a{}", (Object)meetAcceptNeedTicketCount);
            if (meetAcceptNeedTicketCount > 0) {
                TicketOperateDto dto = new TicketOperateDto().setUserId(acceptUserId).setConnectId(meetGroupId).setAmount(meetAcceptNeedTicketCount);
                this.userMeetTicketService.useTicket(dto);
                log.info("\u7528\u6237\uff1a{}\uff0c\u6d88\u8017\u4e86\uff1a{}", (Object)acceptUserId, (Object)meetAcceptNeedTicketCount);
            }
            meetGroup.setMeetAcceptUseTicketCount(meetAcceptNeedTicketCount);
        }
        this.meetGroupService.updateById(meetGroup);
        this.eventPark.post((EventObject)new MeetGroupAcceptedEvent(this, meetGroup, acceptUserId));
        PushTarget pushTarget = new PushTarget();
        pushTarget.setUserId(meetGroup.getInviteUserId());
        pushTarget.addExtend("nickName", meetGroup.getAcceptUserBasicInfo().getNickname());
        this.pusher.doImmediatePush(PushScene.ACCEPT_MEET_REQUEST, pushTarget);
        return meetGroup;
    }

    @Transactional(rollbackFor={Exception.class})
    public MeetGroupDao rejectMeetInvite(Long acceptUserId, Long meetGroupId, String reason) {
        MeetGroupDao meetGroup = this.checkGroupAcceptIsMe(meetGroupId, acceptUserId);
        if (meetGroup.getGroupStatus().intValue() != Constants.MeetGroupConst.GroupStatus.WAIT_ACCEPT.value()) {
            throw new IllegalStateException("\u89c1\u9762\u7fa4\u72b6\u6001\u65e0\u6548");
        }
        if (meetGroup.isExpiredInInviteTimeOut()) {
            throw new IllegalStateException("\u89c1\u9762\u7fa4\u9080\u8bf7\u5df2\u8fc7\u671f");
        }
        this.refundTicket(meetGroupId, meetGroup.getInviteUserId(), TicketReturnTypeEnum.REFUSE);
        meetGroup.setMeetInviteUseTicketCount(0);
        meetGroup.setGroupStatus(Constants.MeetGroupConst.GroupStatus.REJECT.value());
        meetGroup.setInviteUserReadMark(0);
        meetGroup.setAcceptUserReadMark(1);
        meetGroup.setRejectMeetReason(reason);
        this.meetGroupService.updateById(meetGroup);
        this.eventPark.post((EventObject)new MeetGroupRejectedEvent(this, meetGroup, acceptUserId));
        PushTarget pushTarget = new PushTarget();
        pushTarget.setUserId(meetGroup.getInviteUserId());
        pushTarget.addExtend("nickName", meetGroup.getAcceptUserBasicInfo().getNickname());
        this.pusher.doImmediatePush(PushScene.REJECTED_MEET_REQUEST, pushTarget);
        return meetGroup;
    }

    @Transactional(rollbackFor={Exception.class})
    public MeetGroupDao whistleMeetInvite(Long acceptUserId, Long meetGroupId, String reason) {
        MeetGroupDao meetGroup = this.checkGroupAcceptIsMe(meetGroupId, acceptUserId);
        if (meetGroup.getGroupStatus().intValue() != Constants.MeetGroupConst.GroupStatus.WAIT_ACCEPT.value()) {
            throw new IllegalStateException("\u89c1\u9762\u7fa4\u72b6\u6001\u65e0\u6548");
        }
        if (meetGroup.isExpiredInInviteTimeOut()) {
            throw new IllegalStateException("\u89c1\u9762\u7fa4\u9080\u8bf7\u5df2\u8fc7\u671f");
        }
        this.refundTicket(meetGroupId, meetGroup.getInviteUserId(), TicketReturnTypeEnum.REFUSE);
        meetGroup.setMeetInviteUseTicketCount(0);
        meetGroup.setGroupStatus(Constants.MeetGroupConst.GroupStatus.WHISTLE.value());
        meetGroup.setInviteUserReadMark(0);
        meetGroup.setAcceptUserReadMark(1);
        meetGroup.setRejectMeetReason(reason);
        this.meetGroupService.updateById(meetGroup);
        this.eventPark.post((EventObject)new MeetGroupWhistledEvent(this, meetGroup, acceptUserId));
        return meetGroup;
    }

    @Transactional(rollbackFor={Exception.class})
    public void handleInviteTimeout(MeetGroupDao meetGroup) throws IllegalStateException {
        if (!meetGroup.isExpiredInInviteTimeOut()) {
            log.warn("\u89c1\u9762\u7fa4\u9080\u7ea6\u672a\u8d85\u65f6: {}", (Object)meetGroup);
            return;
        }
        if (meetGroup.getGroupStatus().intValue() != Constants.MeetGroupConst.GroupStatus.WAIT_ACCEPT.value()) {
            log.warn("\u89c1\u9762\u7fa4\u9080\u7ea6\u72b6\u6001\u65e0\u6548: {}", (Object)meetGroup);
            return;
        }
        Long meetGroupId = meetGroup.getId();
        this.refundTicket(meetGroupId, meetGroup.getInviteUserId(), TicketReturnTypeEnum.TIME_OUT);
        meetGroup.setMeetInviteUseTicketCount(0);
        meetGroup.setGroupStatus(Constants.MeetGroupConst.GroupStatus.TIMEOUT.value());
        meetGroup.setInviteUserReadMark(0);
        meetGroup.setAcceptUserReadMark(0);
        this.meetGroupService.updateById(meetGroup);
        this.eventPark.post((EventObject)new MeetGroupTimeoutEvent(this, meetGroup, null));
        log.info("\u89c1\u9762\u7fa4\u9080\u7ea6\u5df2\u8d85\u65f6: {}", (Object)meetGroup.getId());
    }

    @Transactional(rollbackFor={Exception.class})
    public MeetGroupMessage sendMessage(MeetGroupMessageSendDto meetGroupMessageSendDto, Long userId) {
        Long meetGroupId = meetGroupMessageSendDto.getMeetGroupId();
        MeetGroupDao meetGroupDao = this.checkGroupInviteOrAcceptIsMine(meetGroupId, userId);
        MeetGroupMessage message = new MeetGroupMessage().setMeetGroupId(meetGroupId).setRole("user").setUserId(userId).setContentType(meetGroupMessageSendDto.getContentType()).setContent(meetGroupMessageSendDto.getContent());
        this.meetGroupMessageService.save(message);
        Long f2f = meetGroupDao.getTA(userId).getUserId();
        this.eventPark.post((EventObject)new MeetGroupNewMessageEvent(this, message, f2f));
        PushTarget pushTarget = new PushTarget();
        pushTarget.setUserId(f2f);
        pushTarget.addExtend("nickName", meetGroupDao.getME(userId).getNickname());
        this.pusher.doImmediatePush(PushScene.NEW_NOTICE, pushTarget);
        return message;
    }

    @Transactional(rollbackFor={Exception.class})
    public MeetGroupMessage sendMessageFromAssistant(MeetGroupMessageSendDto meetGroupMessageSendDto) {
        Long meetGroupId = meetGroupMessageSendDto.getMeetGroupId();
        MeetGroupDao meetGroupDao = this.meetGroupService.getDaoById(meetGroupId);
        if (meetGroupDao == null) {
            throw new IllegalArgumentException("\u627e\u4e0d\u5230\u8be5\u89c1\u9762\u7fa4");
        }
        MeetGroupMessage message = new MeetGroupMessage().setMeetGroupId(meetGroupId).setRole("assistant").setContentType(meetGroupMessageSendDto.getContentType()).setContent(meetGroupMessageSendDto.getContent());
        this.meetGroupMessageService.save(message);
        this.eventPark.post((EventObject)new MeetGroupNewMessageEvent(this, message, meetGroupDao.getInviteUserId()));
        this.eventPark.post((EventObject)new MeetGroupNewMessageEvent(this, message, meetGroupDao.getAcceptUserId()));
        PushTarget pushTarget = new PushTarget();
        pushTarget.setUserId(meetGroupDao.getInviteUserId());
        pushTarget.addExtend("nickName", "\u7ea2\u5a18\u6696\u6696");
        this.pusher.doImmediatePush(PushScene.NEW_NOTICE, pushTarget);
        PushTarget acceptPushTarget = new PushTarget();
        acceptPushTarget.setUserId(meetGroupDao.getAcceptUserId());
        acceptPushTarget.addExtend("nickName", "\u7ea2\u5a18\u6696\u6696");
        this.pusher.doImmediatePush(PushScene.NEW_NOTICE, acceptPushTarget);
        return message;
    }

    @Transactional(rollbackFor={Exception.class})
    public void selectMeetAddress(Long userId, MeetGroupAddressSelectDto meetGroupAddressSelectDto) {
        MeetGroupDao meetGroupDao = this.checkGroupInviteOrAcceptIsMine(meetGroupAddressSelectDto.getMeetGroupId(), userId);
        Integer meetStatus = meetGroupDao.getMeetStatus();
        if (!Objects.equals(meetStatus, Constants.MeetGroupConst.MeetAddressStatus.WAIT_SELECT.value())) {
            throw new IllegalStateException("\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u9009\u62e9\u89c1\u9762\u5730\u5740");
        }
        if (!Objects.equals(meetGroupDao.getMeetSelectAddressUserId(), userId)) {
            throw new IllegalStateException("\u4f60\u6682\u65f6\u4e0d\u80fd\u9009\u62e9\u89c1\u9762\u5730\u5740");
        }
        List<String> meetExpectTimesList = meetGroupAddressSelectDto.getMeetExpectTimesList();
        if (meetExpectTimesList.size() > 24) {
            throw new IllegalArgumentException("\u9009\u62e9\u7684\u65f6\u95f4\u4e0d\u80fd\u8d85\u8fc724\u4e2a");
        }
        meetGroupDao.setMeetAddress(meetGroupAddressSelectDto.getMeetAddress());
        meetGroupDao.setMeetExceptTimes(meetGroupAddressSelectDto.getMeetExceptTimes());
        meetGroupDao.setMeetStatus(Constants.MeetGroupConst.MeetAddressStatus.WAIT_CONFIRM.value());
        this.meetGroupService.updateById(meetGroupDao);
        this.eventPark.post((EventObject)new MeetGroupMeetAddrEvent(this, meetGroupDao, userId));
    }

    @Transactional(rollbackFor={Exception.class})
    public void confirmMeetAddress(Long userId, MeetGroupAddressConfirmDto meetGroupAddressConfirmDto) {
        MeetGroupDao meetGroupDao = this.checkGroupInviteOrAcceptIsMine(meetGroupAddressConfirmDto.getMeetGroupId(), userId);
        if (!Objects.equals(meetGroupDao.getMeetStatus(), Constants.MeetGroupConst.MeetAddressStatus.WAIT_CONFIRM.value())) {
            throw new IllegalStateException("\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u786e\u8ba4\u89c1\u9762\u65f6\u95f4");
        }
        String meetTime = meetGroupAddressConfirmDto.getMeetTime();
        if (!meetGroupDao.getMeetExceptTimes().contains(meetTime)) {
            throw new IllegalArgumentException("\u65f6\u95f4\u6bb5\u65e0\u6548");
        }
        String date = meetTime.split(" ")[0];
        String times = meetTime.split(" ")[1];
        String s = times.split("-")[0];
        String e = times.split("-")[1];
        LocalDateTime start = LocalDateTime.parse(date + " " + s, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
        LocalDateTime end = LocalDateTime.parse(date + " " + e, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
        meetGroupDao.setMeetTime(meetTime);
        meetGroupDao.setMeetTimeStart(start);
        meetGroupDao.setMeetTimeEnd(end);
        meetGroupDao.setMeetStatus(Constants.MeetGroupConst.MeetAddressStatus.CONFIRM.value());
        this.meetGroupService.updateById(meetGroupDao);
        UserBasicInfo me = meetGroupDao.getME(userId);
        String content = String.format("%s\u5df2\u7ecf\u786e\u8ba4\u89c1\u9762\u5730\u70b9\u548c\u65f6\u95f4\uff0c\u89c1\u9762\u5730\u70b9\uff1a%s\uff0c\u89c1\u9762\u65f6\u95f4\uff1a%s", me.getNickname(), meetGroupDao.getMeetAddress(), meetGroupDao.getMeetTime());
        MeetGroupMessageSendDto meetGroupMessageSendDto = new MeetGroupMessageSendDto().setContentType(Constants.MeetGroupMessageConst.CONTENT_TYPE_TEXT).setContent(content).setMeetGroupId(meetGroupAddressConfirmDto.getMeetGroupId());
        this.sendMessageFromAssistant(meetGroupMessageSendDto);
        this.eventPark.post((EventObject)new MeetGroupMeetAddrEvent(this, meetGroupDao, userId));
    }

    @Transactional(rollbackFor={Exception.class})
    public void rejectMeetAddress(Long userId, MeetGroupAddressRejectDto meetGroupAddressRejectDto) {
        MeetGroupDao meetGroupDao = this.checkGroupInviteOrAcceptIsMine(meetGroupAddressRejectDto.getMeetGroupId(), userId);
        if (!Objects.equals(meetGroupDao.getMeetStatus(), Constants.MeetGroupConst.MeetAddressStatus.WAIT_CONFIRM.value())) {
            throw new IllegalStateException("\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u62d2\u7edd\u89c1\u9762\u5730\u5740");
        }
        meetGroupDao.setRejectMeetReason(meetGroupAddressRejectDto.getReason());
        meetGroupDao.setMeetStatus(Constants.MeetGroupConst.MeetAddressStatus.WAIT_SELECT.value());
        this.meetGroupService.updateById(meetGroupDao);
        UserBasicInfo me = meetGroupDao.getME(userId);
        UserBasicInfo ta = meetGroupDao.getTA(userId);
        String content = String.format("@%s\uff0c\u7531\u4e8e%s\u7684\u65f6\u95f4\u4e0d\u5408\u9002\uff0c\u9ebb\u70e6\u4f60\u91cd\u65b0\u9009\u62e9\u4e00\u4e0b\u89c1\u9762\u5730\u5740\u548c\u65f6\u95f4\u54e6\u3002", ta.getNickname(), me.getNickname());
        MeetGroupMessageSendDto meetGroupMessageSendDto = new MeetGroupMessageSendDto().setContentType(Constants.MeetGroupMessageConst.CONTENT_TYPE_TEXT).setContent(content).setMeetGroupId(meetGroupAddressRejectDto.getMeetGroupId());
        this.sendMessageFromAssistant(meetGroupMessageSendDto);
        this.eventPark.post((EventObject)new MeetGroupMeetAddrEvent(this, meetGroupDao, userId));
    }

    public void confirmMeetResult(Long userId, MeetGroupConfirmMeetResultDto meetGroupConfirmMeetResultDto) {
        Long meetGroupId = meetGroupConfirmMeetResultDto.getMeetGroupId();
        MeetGroupDao meetGroupDao = this.checkGroupInviteOrAcceptIsMine(meetGroupId, userId);
        if (!Objects.equals(meetGroupDao.getMeetStatus(), Constants.MeetGroupConst.MeetAddressStatus.CONFIRM.value())) {
            throw new IllegalStateException("\u4ec5\u786e\u8ba4\u4e86\u89c1\u9762\u5730\u70b9\u548c\u65f6\u95f4\u7684\u624d\u80fd\u786e\u8ba4\u89c1\u9762\u7ed3\u679c");
        }
        LocalDateTime meetTimeStart = meetGroupDao.getMeetTimeStart();
        if (null == meetTimeStart || meetTimeStart.isAfter(LocalDateTime.now())) {
            throw new IllegalStateException("\u89c1\u9762\u65f6\u95f4\u672a\u5f00\u59cb");
        }
        Integer meetResult = meetGroupConfirmMeetResultDto.getMeetResult();
        String description = meetGroupConfirmMeetResultDto.getDescription();
        meetGroupDao.updateMeetResultForMe(userId, meetResult, description);
        boolean inviteNotMeet = Objects.equals(meetGroupDao.getMeetInviteUserResult(), Constants.MeetGroupConst.MeetResult.NOT_MEET.value());
        boolean acceptNotMeet = Objects.equals(meetGroupDao.getMeetAcceptUserResult(), Constants.MeetGroupConst.MeetResult.NOT_MEET.value());
        if (inviteNotMeet || acceptNotMeet) {
            meetGroupDao.setMeetStatus(Constants.MeetGroupConst.MeetAddressStatus.WAIT_SELECT.value());
            meetGroupDao.setMeetAddress(null);
            meetGroupDao.setMeetExceptTimes(null);
            meetGroupDao.setMeetTime(null);
            meetGroupDao.setMeetTimeStart(null);
            meetGroupDao.setMeetTimeEnd(null);
        }
        boolean inviteMeet = Objects.equals(meetGroupDao.getMeetInviteUserResult(), Constants.MeetGroupConst.MeetResult.MEET.value());
        boolean acceptMeet = Objects.equals(meetGroupDao.getMeetAcceptUserResult(), Constants.MeetGroupConst.MeetResult.MEET.value());
        if (inviteMeet && acceptMeet) {
            meetGroupDao.setGroupStatus(Constants.MeetGroupConst.GroupStatus.MEET_SUCCESS.value());
        }
        this.meetGroupService.updateById(meetGroupDao);
        this.eventPark.post((EventObject)new MeetGroupMeetAddrEvent(this, meetGroupDao, userId));
    }

    public String getVirtualPhoneNumber(Long meetGroupId, Long userId) {
        MeetGroupDao meetGroupDao = this.checkGroupInviteOrAcceptIsMine(meetGroupId, userId);
        Long inviteUserId = meetGroupDao.getInviteUserId();
        Long acceptUserId = meetGroupDao.getAcceptUserId();
        User inviteUser = (User)this.userService.getById(inviteUserId);
        User acceptUser = (User)this.userService.getById(acceptUserId);
        boolean iAmInvite = Objects.equals(inviteUserId, userId);
        String a = iAmInvite ? inviteUser.getMobile() : acceptUser.getMobile();
        String b = iAmInvite ? acceptUser.getMobile() : inviteUser.getMobile();
        VirtualPhoneNumberBindResult bindResult = this.virtualPhoneNumberService.rebind(a, b);
        return bindResult.getVirtualNumber();
    }

    public MeetGroupDao checkGroupInviteOrAcceptIsMine(Long meetGroupId, Long userId) throws IllegalArgumentException {
        boolean is;
        MeetGroupDao meetGroup = this.meetGroupService.getDaoById(meetGroupId);
        boolean bl = is = null != meetGroup && (Objects.equals(meetGroup.getInviteUserId(), userId) || Objects.equals(meetGroup.getAcceptUserId(), userId));
        if (!is) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u89c1\u9762\u7fa4");
        }
        return meetGroup;
    }

    public MeetGroupDao checkGroupAcceptIsMe(Long meetGroupId, Long userId) {
        boolean is;
        MeetGroupDao meetGroup = this.meetGroupService.getDaoById(meetGroupId);
        boolean bl = is = null != meetGroup && Objects.equals(meetGroup.getAcceptUserId(), userId);
        if (!is) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u89c1\u9762\u7fa4");
        }
        return meetGroup;
    }

    private void refundTicket(Long meetGroupId, Long userId, TicketReturnTypeEnum returnType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"connect_id", (Object)meetGroupId)).eq((Object)"type", (Object)TicketRecordTypeEnum.USE.getOrdinal())).eq((Object)"user_id", (Object)userId);
        UserMeetTicketRecord userMeetTicketRecord = (UserMeetTicketRecord)this.userMeetTicketRecordService.getOne((Wrapper)queryWrapper);
        if (userMeetTicketRecord == null) {
            log.info("\u89c1\u9762\u7fa4\uff1a{}\uff0c\u7528\u6237\uff1a{}\uff0c\u6ca1\u6709\u4f7f\u7528\u7ea2\u8c46\uff0c\u4e0d\u9700\u8981\u9000\u56de", (Object)meetGroupId, (Object)userId);
            return;
        }
        ReturnTicketOperateDto ticketOperateDto = new ReturnTicketOperateDto().setAmount(userMeetTicketRecord.getAmount()).setConnectId(meetGroupId).setUserId(userId).setReturnType(returnType);
        this.userMeetTicketService.returnTicket(ticketOperateDto);
        log.info("\u89c1\u9762\u7fa4\uff1a{}\uff0c\u7528\u6237\uff1a{}\uff0c\u9000\u8c46\u6210\u529f\uff01\u9000\u8c46\u60c5\u51b5\uff1a{}", new Object[]{meetGroupId, userId, ticketOperateDto});
    }

    private UserBasicInfo filterFemale(Map<Long, UserBasicInfo> userBasicInfoMap) {
        return userBasicInfoMap.values().stream().filter(e -> e.getGender() == 0).findFirst().orElse(null);
    }

    private UserBasicInfo filterMale(Map<Long, UserBasicInfo> userBasicInfoMap) {
        return userBasicInfoMap.values().stream().filter(e -> e.getGender() == 1).findFirst().orElse(null);
    }

    private UserBasicInfo getFirstFemale(Object ... userId) {
        Map<Long, UserBasicInfo> userBasicInfoMap = this.getUserBasicInfoMap(userId);
        return this.filterFemale(userBasicInfoMap);
    }

    private Map<Long, UserBasicInfo> getUserBasicInfoMap(Object ... userId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(UserBasicInfo::getUserId, userId);
        List list = this.userBasicInfoService.list((Wrapper)queryWrapper);
        return list.stream().collect(Collectors.toMap(UserBasicInfo::getUserId, Function.identity()));
    }

    public MeetGroupManager(IMeetGroupService meetGroupService, IMeetGroupMessageService meetGroupMessageService, IUserService userService, IUserBasicInfoService userBasicInfoService, IUserMeetTicketService userMeetTicketService, IUserMeetTicketRecordService userMeetTicketRecordService, IActivityUserMutualSelectionService activityUserMutualSelectionService, ISensitiveService sensitiveService, VirtualPhoneNumberService virtualPhoneNumberService, EventPark eventPark, Pusher pusher, TextCompletionFacadeIntegration textCompletionFacadeIntegration) {
        this.meetGroupService = meetGroupService;
        this.meetGroupMessageService = meetGroupMessageService;
        this.userService = userService;
        this.userBasicInfoService = userBasicInfoService;
        this.userMeetTicketService = userMeetTicketService;
        this.userMeetTicketRecordService = userMeetTicketRecordService;
        this.activityUserMutualSelectionService = activityUserMutualSelectionService;
        this.sensitiveService = sensitiveService;
        this.virtualPhoneNumberService = virtualPhoneNumberService;
        this.eventPark = eventPark;
        this.pusher = pusher;
        this.textCompletionFacadeIntegration = textCompletionFacadeIntegration;
    }
}

