/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.manager;

import com.bxm.lovelink.common.dal.entity.User;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.entity.dao.MeetGroupDao;
import com.bxm.lovelink.common.dal.service.IMeetGroupService;
import com.bxm.lovelink.common.dal.service.IUserService;
import com.bxm.warcar.utils.TypeHelper;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service
public class MeetGroupMessageInvalidUnreadCountManager
implements InitializingBean,
DisposableBean {
    private final IMeetGroupService meetGroupService;
    private final IUserService userService;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final BlockingQueue<QueueItem> queue = new LinkedBlockingQueue<QueueItem>(1000);

    public MeetGroupMessageInvalidUnreadCountManager(IMeetGroupService meetGroupService, IUserService userService) {
        this.meetGroupService = meetGroupService;
        this.userService = userService;
    }

    public void add2Queue(QueueItem queueItem) {
        if (Objects.nonNull(queueItem)) {
            this.queue.offer(queueItem);
        }
    }

    public void afterPropertiesSet() {
        this.executor.execute(() -> {
            while (true) {
                try {
                    while (true) {
                        QueueItem queueItem = this.queue.take();
                        this.removeIf(queueItem);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        });
    }

    public void destroy() {
        this.executor.shutdownNow();
    }

    private void removeIf(QueueItem queueItem) {
        final Long userId = queueItem.getUserId();
        Map<String, Integer> meetGroupId2Count = queueItem.getMeetGroupId2Count();
        List waitRemoveItems = meetGroupId2Count.keySet().stream().filter(meetGroupId -> {
            MeetGroupDao meetGroup = this.meetGroupService.getDaoById(TypeHelper.castToLong((Object)meetGroupId));
            if (Objects.isNull(meetGroup) || Objects.equals(meetGroup.getDeleted(), 1)) {
                return true;
            }
            UserBasicInfo ta = meetGroup.getTA(userId);
            Long taUserId = ta.getUserId();
            User taUser = (User)this.userService.getById(taUserId);
            return Objects.isNull(taUser) || Objects.equals(taUser.getDeleted(), 1);
        }).map(new Function<String, WaitRemoveItem>(){

            @Override
            public WaitRemoveItem apply(String meetGroupId) {
                return new WaitRemoveItem(userId, Long.valueOf(meetGroupId));
            }
        }).collect(Collectors.toList());
        Consumer<List<WaitRemoveItem>> removeHandler = queueItem.getRemoveHandler();
        if (removeHandler != null) {
            removeHandler.accept(waitRemoveItems);
        }
    }

    public static class WaitRemoveItem {
        private Long userId;
        private Long meetGroupId;

        public Long getUserId() {
            return this.userId;
        }

        public Long getMeetGroupId() {
            return this.meetGroupId;
        }

        public void setUserId(Long userId) {
            this.userId = userId;
        }

        public void setMeetGroupId(Long meetGroupId) {
            this.meetGroupId = meetGroupId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WaitRemoveItem)) {
                return false;
            }
            WaitRemoveItem other = (WaitRemoveItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$userId = this.getUserId();
            Long other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
                return false;
            }
            Long this$meetGroupId = this.getMeetGroupId();
            Long other$meetGroupId = other.getMeetGroupId();
            return !(this$meetGroupId == null ? other$meetGroupId != null : !((Object)this$meetGroupId).equals(other$meetGroupId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WaitRemoveItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
            Long $meetGroupId = this.getMeetGroupId();
            result = result * 59 + ($meetGroupId == null ? 43 : ((Object)$meetGroupId).hashCode());
            return result;
        }

        public String toString() {
            return "MeetGroupMessageInvalidUnreadCountManager.WaitRemoveItem(userId=" + this.getUserId() + ", meetGroupId=" + this.getMeetGroupId() + ")";
        }

        public WaitRemoveItem(Long userId, Long meetGroupId) {
            this.userId = userId;
            this.meetGroupId = meetGroupId;
        }
    }

    public static class QueueItem {
        private Long userId;
        private Map<String, Integer> meetGroupId2Count;
        private Consumer<List<WaitRemoveItem>> removeHandler;

        public Long getUserId() {
            return this.userId;
        }

        public Map<String, Integer> getMeetGroupId2Count() {
            return this.meetGroupId2Count;
        }

        public Consumer<List<WaitRemoveItem>> getRemoveHandler() {
            return this.removeHandler;
        }

        public void setUserId(Long userId) {
            this.userId = userId;
        }

        public void setMeetGroupId2Count(Map<String, Integer> meetGroupId2Count) {
            this.meetGroupId2Count = meetGroupId2Count;
        }

        public void setRemoveHandler(Consumer<List<WaitRemoveItem>> removeHandler) {
            this.removeHandler = removeHandler;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueueItem)) {
                return false;
            }
            QueueItem other = (QueueItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$userId = this.getUserId();
            Long other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
                return false;
            }
            Map<String, Integer> this$meetGroupId2Count = this.getMeetGroupId2Count();
            Map<String, Integer> other$meetGroupId2Count = other.getMeetGroupId2Count();
            if (this$meetGroupId2Count == null ? other$meetGroupId2Count != null : !((Object)this$meetGroupId2Count).equals(other$meetGroupId2Count)) {
                return false;
            }
            Consumer<List<WaitRemoveItem>> this$removeHandler = this.getRemoveHandler();
            Consumer<List<WaitRemoveItem>> other$removeHandler = other.getRemoveHandler();
            return !(this$removeHandler == null ? other$removeHandler != null : !this$removeHandler.equals(other$removeHandler));
        }

        protected boolean canEqual(Object other) {
            return other instanceof QueueItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
            Map<String, Integer> $meetGroupId2Count = this.getMeetGroupId2Count();
            result = result * 59 + ($meetGroupId2Count == null ? 43 : ((Object)$meetGroupId2Count).hashCode());
            Consumer<List<WaitRemoveItem>> $removeHandler = this.getRemoveHandler();
            result = result * 59 + ($removeHandler == null ? 43 : $removeHandler.hashCode());
            return result;
        }

        public String toString() {
            return "MeetGroupMessageInvalidUnreadCountManager.QueueItem(userId=" + this.getUserId() + ", meetGroupId2Count=" + this.getMeetGroupId2Count() + ", removeHandler=" + this.getRemoveHandler() + ")";
        }

        public QueueItem(Long userId, Map<String, Integer> meetGroupId2Count, Consumer<List<WaitRemoveItem>> removeHandler) {
            this.userId = userId;
            this.meetGroupId2Count = meetGroupId2Count;
            this.removeHandler = removeHandler;
        }
    }
}

