/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.manager;

import com.bxm.lovelink.common.dal.manager.MeetGroupMessageInvalidUnreadCountManager;
import com.bxm.lovelink.constant.RedisKeys;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Component;

@Component
public class MeetGroupMessageUnreadCountManager {
    private final Fetcher fetcher;
    private final Updater updater;
    private final Counter counter;
    private final MeetGroupMessageInvalidUnreadCountManager meetGroupMessageInvalidUnreadCountManager;

    public void increment(Long userId, Long meetGroupId) {
        KeyGenerator keyGenerator = RedisKeys.hashMeetGroupUnreadCount((Long)userId);
        this.counter.hincrementAndGet(keyGenerator, meetGroupId.toString());
    }

    public void remove(Long userId, Long meetGroupId) {
        KeyGenerator keyGenerator = RedisKeys.hashMeetGroupUnreadCount((Long)userId);
        this.updater.hremove(keyGenerator, new String[]{meetGroupId.toString()});
    }

    public Long query(Long userId, Long meetGroupId) {
        KeyGenerator keyGenerator = RedisKeys.hashMeetGroupUnreadCount((Long)userId);
        return this.counter.hget(keyGenerator, meetGroupId.toString());
    }

    public Map<String, Integer> queryAll(Long userId) {
        KeyGenerator keyGenerator = RedisKeys.hashMeetGroupUnreadCount((Long)userId);
        Map fetchedMap = this.fetcher.hfetchall(keyGenerator, Long.class);
        if (MapUtils.isEmpty((Map)fetchedMap)) {
            return Collections.emptyMap();
        }
        Map<String, Integer> map = fetchedMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Long)e.getValue()).intValue()));
        MeetGroupMessageInvalidUnreadCountManager.QueueItem queueItem = new MeetGroupMessageInvalidUnreadCountManager.QueueItem(userId, map, waitRemoveItems -> {
            for (MeetGroupMessageInvalidUnreadCountManager.WaitRemoveItem item : waitRemoveItems) {
                Long userId1 = item.getUserId();
                Long meetGroupId = item.getMeetGroupId();
                this.remove(userId1, meetGroupId);
            }
        });
        this.meetGroupMessageInvalidUnreadCountManager.add2Queue(queueItem);
        return map;
    }

    public MeetGroupMessageUnreadCountManager(Fetcher fetcher, Updater updater, Counter counter, MeetGroupMessageInvalidUnreadCountManager meetGroupMessageInvalidUnreadCountManager) {
        this.fetcher = fetcher;
        this.updater = updater;
        this.counter = counter;
        this.meetGroupMessageInvalidUnreadCountManager = meetGroupMessageInvalidUnreadCountManager;
    }
}

