/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.manager;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bxm.lovelink.common.chat.ByteWriter;
import com.bxm.lovelink.common.chat.ChatRequest;
import com.bxm.lovelink.common.chat.ChatService;
import com.bxm.lovelink.common.chat.CompleteConsumer;
import com.bxm.lovelink.common.chat.SimpleHandler;
import com.bxm.lovelink.common.dal.entity.ChatSession;
import com.bxm.lovelink.common.dal.entity.ChatSessionMessage;
import com.bxm.lovelink.common.dal.entity.User;
import com.bxm.lovelink.common.dal.entity.dto.chat.WecomChatDto;
import com.bxm.lovelink.common.dal.manager.parameter.ParameterBuilderFactory;
import com.bxm.lovelink.common.dal.manager.parameter.ParameterBuilderRequest;
import com.bxm.lovelink.common.dal.service.IChatSessionMessageService;
import com.bxm.lovelink.common.dal.service.IChatSessionService;
import com.bxm.lovelink.common.dal.service.IUserService;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import org.apache.catalina.connector.ClientAbortException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WecomChatManager {
    private static final Logger log = LoggerFactory.getLogger(WecomChatManager.class);
    private final IUserService userService;
    private final IChatSessionService chatSessionService;
    private final IChatSessionMessageService chatSessionMessageService;
    private final ChatService chatService;
    private final ParameterBuilderFactory parameterBuilderFactory;

    public WecomChatManager(IUserService userService, IChatSessionService chatSessionService, IChatSessionMessageService chatSessionMessageService, ChatService chatService, ParameterBuilderFactory parameterBuilderFactory) {
        this.userService = userService;
        this.chatSessionService = chatSessionService;
        this.chatSessionMessageService = chatSessionMessageService;
        this.chatService = chatService;
        this.parameterBuilderFactory = parameterBuilderFactory;
    }

    public void streamChat(User user, WecomChatDto wecomChatDto, ByteWriter<byte[]> writeConsumer, SimpleHandler flusher, CompleteConsumer completeConsumer, BiConsumer<ClientAbortException, String> clientAbortExceptionStringBiConsumer) {
        boolean isFistChat;
        Long userId = user.getId();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ChatSession.class).eq(ChatSession::getUserId, (Object)userId)).eq(ChatSession::getSceneType, (Object)wecomChatDto.getSceneType());
        ChatSession session = (ChatSession)this.chatSessionService.getOne((Wrapper)queryWrapper);
        boolean bl = isFistChat = null == session;
        if (isFistChat) {
            session = new ChatSession();
            session.setUserId(userId);
            session.setSceneType(2);
            session.setExt(wecomChatDto.getUnionId());
            this.chatSessionService.save(session);
        }
        ArrayList<ChatSessionMessage> messageList = new ArrayList<ChatSessionMessage>();
        if (isFistChat && wecomChatDto.getWelcomeContent() != null) {
            messageList.add(wecomChatDto.to().setContent(wecomChatDto.getWelcomeContent()).setSessionId(session.getId()).setRole("assistant"));
        }
        messageList.add(wecomChatDto.to().setSessionId(session.getId()).setRole("user"));
        messageList.forEach(arg_0 -> ((IChatSessionMessageService)this.chatSessionMessageService).save(arg_0));
        long start = System.currentTimeMillis();
        ChatRequest chatRequest = ChatRequest.builder().user(user).chatSession(session).chatSessionMessages(messageList).parameter(this.parameterBuilderFactory.build(ParameterBuilderRequest.builder().userId(userId).chatSession(session).apiChatDto(wecomChatDto).me(this.userService.getCompositeById(userId)).build())).writeConsumer(writeConsumer).flusher(flusher).complete(messages -> {
            ChatSessionMessage lastMessage = (ChatSessionMessage)messages.get(messages.size() - 1);
            this.chatSessionMessageService.save(lastMessage);
            if (null != completeConsumer) {
                completeConsumer.accept(messages);
            }
            log.info("\u4f01\u5fae\u804a\u5929\u5927\u6a21\u578b\u8017\u65f6{}ms", (Object)(System.currentTimeMillis() - start));
        }).clientAbortExceptionStringBiConsumer(clientAbortExceptionStringBiConsumer).build();
        this.chatService.stream(chatRequest);
    }
}

