/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.manager.parameter.builders;

import cn.hutool.core.io.IoUtil;
import com.bxm.lovelink.common.dal.entity.Region;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.entity.UserComposite;
import com.bxm.lovelink.common.dal.entity.UserTag;
import com.bxm.lovelink.common.dal.manager.parameter.ParameterBuilder;
import com.bxm.lovelink.common.dal.manager.parameter.ParameterBuilderRequest;
import com.bxm.lovelink.common.dal.manager.parameter.parser.VelocityPromptParser;
import com.bxm.lovelink.common.dal.service.IRegionService;
import com.bxm.lovelink.common.dal.service.IUserTagService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class UserProfileBuilder
implements ParameterBuilder {
    private static final Logger log = LoggerFactory.getLogger(UserProfileBuilder.class);
    private final IRegionService regionService;
    private final IUserTagService userTagService;
    private final Resource resource;

    public UserProfileBuilder(IRegionService regionService, IUserTagService userTagService) {
        this.regionService = regionService;
        this.userTagService = userTagService;
        this.resource = new ClassPathResource("llm_param_for_user_profile.vm");
    }

    @Override
    public String key() {
        return "user_a_profile";
    }

    protected UserComposite getUserComposite(ParameterBuilderRequest parameterBuilderRequest) {
        return parameterBuilderRequest.getMe();
    }

    @Override
    public Object apply(ParameterBuilderRequest parameterBuilderRequest) {
        UserComposite userComposite = this.getUserComposite(parameterBuilderRequest);
        if (userComposite == null) {
            return null;
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("userComposite", userComposite);
        UserBasicInfo userBasicInfo = userComposite.getUserBasicInfo();
        if (null != userBasicInfo) {
            Map<Integer, String> regionMap = this.regionService.fetchAll(Region::getFullName);
            variables.put("currentPlaceDistrict", regionMap.get(userBasicInfo.getCurrentPlaceDistrict()));
            variables.put("nativePlaceDistrict", regionMap.get(userBasicInfo.getNativePlaceDistrict()));
            variables.put("interestList", this.fetchInterestTags(userBasicInfo.getInterestTag()));
        }
        VelocityPromptParser parser = new VelocityPromptParser(variables);
        String string = this.readFull(this.resource);
        return parser.process(string);
    }

    protected String readFull(Resource resource) {
        try {
            return IoUtil.read((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            log.error("\u3010velocity-template\u3011\u8bfb\u53d6\u6a21\u677f\u5f02\u5e38\uff0cresource:{}", (Object)resource);
            return null;
        }
    }

    protected List<String> fetchInterestTags(List<Long> interestTagIds) {
        if (CollectionUtils.isEmpty(interestTagIds)) {
            return Collections.emptyList();
        }
        Map<Long, String> userTagMap = this.userTagService.fetchAll(UserTag::getTagName);
        return interestTagIds.stream().filter(Objects::nonNull).map(userTagMap::get).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

