/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.lovelink.common.dal.entity.ActivityEvaluation;
import com.bxm.lovelink.common.dal.entity.dto.activity.evaluation.ActivityEvaluationDto;
import com.bxm.lovelink.common.dal.mapper.ActivityEvaluationMapper;
import com.bxm.lovelink.common.dal.mapping.activity.ActivityEvaluationMapping;
import com.bxm.lovelink.common.dal.service.IActivityEvaluationService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service
public class ActivityEvaluationServiceImpl
extends ServiceImpl<ActivityEvaluationMapper, ActivityEvaluation>
implements IActivityEvaluationService {
    @Override
    public void submitEvaluation(ActivityEvaluationDto dto, Long userId) {
        if (Objects.isNull(dto)) {
            throw new IllegalArgumentException("\u8bc4\u4ef7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ActivityEvaluation activityEvaluation = (ActivityEvaluation)((ActivityEvaluationMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ActivityEvaluation::getActivityId, (Object)dto.getActivityId())).eq(ActivityEvaluation::getUserId, (Object)userId));
        if (Objects.nonNull(activityEvaluation)) {
            throw new IllegalArgumentException("\u5df2\u7ecf\u8bc4\u4ef7\u8fc7\u8be5\u6d3b\u52a8");
        }
        dto.validateEvaluation();
        ActivityEvaluation evaluation = ActivityEvaluationMapping.INSTANCE.dtoToDo(dto);
        evaluation.setUserId(userId);
        List<Integer> scores = Arrays.asList(dto.getHostScore(), dto.getContentScore(), dto.getGuestQualityScore(), dto.getCostScore(), dto.getOverallScore());
        IntSummaryStatistics statistics = scores.stream().filter(Objects::nonNull).mapToInt(Integer::intValue).summaryStatistics();
        if (statistics.getCount() != 0L) {
            evaluation.setAvgScore(BigDecimal.valueOf(statistics.getSum()).divide(BigDecimal.valueOf(statistics.getCount()), 2, RoundingMode.HALF_UP));
        }
        ((ActivityEvaluationMapper)this.baseMapper).insert(evaluation);
    }
}

