/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.lovelink.common.dal.entity.Activity;
import com.bxm.lovelink.common.dal.entity.ActivityRegistration;
import com.bxm.lovelink.common.dal.entity.ActivityRegistrationData;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.entity.UserOrder;
import com.bxm.lovelink.common.dal.entity.dto.activity.evaluation.ActivityRegisterDto;
import com.bxm.lovelink.common.dal.entity.vo.activity.ActivityPayConfigVo;
import com.bxm.lovelink.common.dal.entity.vo.activity.registration.ActivityRegistrationResultVo;
import com.bxm.lovelink.common.dal.entity.vo.activity.usermutualselection.ActivityUserVo;
import com.bxm.lovelink.common.dal.mapper.ActivityMapper;
import com.bxm.lovelink.common.dal.mapper.ActivityRegistrationMapper;
import com.bxm.lovelink.common.dal.service.IActivityRegistrationService;
import com.bxm.lovelink.common.dal.service.IActivityUserMutualSelectionService;
import com.bxm.lovelink.common.dal.service.IUserOrderService;
import com.bxm.lovelink.constant.RedisKeys;
import com.bxm.warcar.id.IdGenerator;
import com.bxm.warcar.integration.pair.Pair;
import com.bxm.warcar.utils.JsonHelper;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivityRegistrationServiceImpl
extends ServiceImpl<ActivityRegistrationMapper, ActivityRegistration>
implements IActivityRegistrationService {
    private static final Logger log = LoggerFactory.getLogger(ActivityRegistrationServiceImpl.class);
    private final ActivityMapper activityMapper;
    private final IdGenerator idGenerator;
    private final IUserOrderService userOrderService;
    private final RedissonClient redissonClient;
    private final IActivityUserMutualSelectionService activityUserMutualSelectionService;
    private final Pair pair;

    public ActivityRegistrationServiceImpl(ActivityMapper activityMapper, @Qualifier(value="orderIdGenerator") IdGenerator idGenerator, IUserOrderService userOrderService, RedissonClient redissonClient, IActivityUserMutualSelectionService activityUserMutualSelectionService, Pair pair) {
        this.activityMapper = activityMapper;
        this.idGenerator = idGenerator;
        this.userOrderService = userOrderService;
        this.redissonClient = redissonClient;
        this.activityUserMutualSelectionService = activityUserMutualSelectionService;
        this.pair = pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public ActivityRegistrationResultVo register(ActivityRegisterDto dto, UserBasicInfo userBasicInfo) {
        Long userId = userBasicInfo.getUserId();
        Long activityId = dto.getActivityId();
        LocalDateTime now = LocalDateTime.now();
        Activity activity = (Activity)this.activityMapper.selectById(activityId);
        this.validateActivity(activity);
        RLock lock = this.redissonClient.getLock(RedisKeys.activityRegisterLock((Long)userId, (Long)activityId).generateKey());
        boolean locked = lock.tryLock();
        if (!locked) {
            throw new IllegalStateException("\u6b63\u5728\u62a5\u540d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        try {
            UserOrder userOrder;
            ActivityRegistration activityRegistration = this.getActivityRegistration(activityId, userId, 2);
            if (activityRegistration != null) {
                throw new IllegalStateException("\u5df2\u7ecf\u62a5\u540d\u8fc7\u4e86");
            }
            ActivityRegistration waitPay = this.getWaitPayActivityRegistration(activityId, userId);
            if (waitPay != null && Objects.nonNull(userOrder = this.userOrderService.query(waitPay.getOrderNo())) && userOrder.getStatus() < 2) {
                ActivityRegistrationResultVo activityRegistrationResultVo = ActivityRegistrationResultVo.buildWaitPayResult(activityId, waitPay.getOrderNo(), userOrder.getTotalPrice(), this.getAppleProductId(userOrder.getPaymentAmount()));
                return activityRegistrationResultVo;
            }
            Integer canRegister = this.activityMapper.canRegister(activityId, userBasicInfo.getGender());
            if (Objects.isNull(canRegister) || !canRegister.equals(1)) {
                ActivityRegistrationResultVo activityRegistrationResultVo = ActivityRegistrationResultVo.buildFailResult(activityId, 1);
                return activityRegistrationResultVo;
            }
            if (this.isFree(activity, userId)) {
                boolean result = this.registerUser(dto.getActivityId(), userBasicInfo, 2, false, null);
                if (!result) {
                    ActivityRegistrationResultVo activityRegistrationResultVo = ActivityRegistrationResultVo.buildFailResult(activityId, 1);
                    return activityRegistrationResultVo;
                }
                ActivityRegistrationResultVo activityRegistrationResultVo = ActivityRegistrationResultVo.buildFreeResult(activityId, BigDecimal.ZERO);
                return activityRegistrationResultVo;
            }
            if (this.useFreeQualification(userId, activity.getActivityTypeId())) {
                boolean result = this.registerUser(dto.getActivityId(), userBasicInfo, 2, false, null);
                if (!result) {
                    ActivityRegistrationResultVo activityRegistrationResultVo = ActivityRegistrationResultVo.buildFailResult(activityId, 1);
                    return activityRegistrationResultVo;
                }
                ActivityRegistrationResultVo activityRegistrationResultVo = ActivityRegistrationResultVo.buildFreeResult(activityId, BigDecimal.ZERO);
                return activityRegistrationResultVo;
            }
            if (!dto.getIsOriginalPriceRegister().booleanValue() && this.hasDiscount(activity)) {
                if (this.hasValidDiscount(activity, now)) {
                    String orderNo = this.createOrder(dto, userId, activity, activity.getDiscountPrice());
                    boolean result = this.registerUser(dto.getActivityId(), userBasicInfo, 0, true, orderNo);
                    if (!result) {
                        this.releaseDiscountRegisterCount(activity);
                        ActivityRegistrationResultVo activityRegistrationResultVo = ActivityRegistrationResultVo.buildFailResult(activityId, 1);
                        return activityRegistrationResultVo;
                    }
                    ActivityRegistrationResultVo activityRegistrationResultVo = ActivityRegistrationResultVo.buildPayResult(activityId, orderNo, activity.getDiscountPrice(), this.getAppleProductId(activity.getDiscountPrice()));
                    return activityRegistrationResultVo;
                }
                ActivityRegistrationResultVo orderNo = ActivityRegistrationResultVo.buildFailResult(activityId, 2, activity.getRegisterPrice());
                return orderNo;
            }
            String orderNo = this.createOrder(dto, userId, activity, activity.getRegisterPrice());
            boolean result = this.registerUser(dto.getActivityId(), userBasicInfo, 0, false, orderNo);
            if (!result) {
                ActivityRegistrationResultVo activityRegistrationResultVo = ActivityRegistrationResultVo.buildFailResult(activityId, 1);
                return activityRegistrationResultVo;
            }
            ActivityRegistrationResultVo activityRegistrationResultVo = ActivityRegistrationResultVo.buildPayResult(activityId, orderNo, activity.getRegisterPrice(), this.getAppleProductId(activity.getRegisterPrice()));
            return activityRegistrationResultVo;
        }
        finally {
            lock.unlock();
        }
    }

    private void releaseDiscountRegisterCount(Activity activity) {
        if (Objects.nonNull(activity.getDiscountLimitType()) && activity.getDiscountLimitType() == 2) {
            this.activityMapper.releaseDiscountRegisterCount(activity.getId());
        }
    }

    private boolean registerUser(Long activityId, UserBasicInfo userBasicInfo, int status, boolean discount, String orderNo) {
        boolean success = this.tryRegister(activityId, userBasicInfo);
        if (!success) {
            return false;
        }
        Integer insert = this.insertRegistration(activityId, userBasicInfo, status, discount, orderNo);
        return insert == 1;
    }

    private boolean isFree(Activity activity, Long userId) {
        if (Objects.isNull(activity.getRegisterPrice()) || activity.getRegisterPrice().compareTo(BigDecimal.ZERO) <= 0) {
            return true;
        }
        if (1 == activity.getNewUserFree() && Objects.nonNull(userId)) {
            return ((ActivityRegistrationMapper)this.baseMapper).selectCount((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ActivityRegistration::getUserId, (Object)userId)).eq(ActivityRegistration::getStatus, (Object)2)) <= 0;
        }
        return false;
    }

    private boolean useFreeQualification(Long userId, Long typeId) {
        List list = ((ActivityRegistrationMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ActivityRegistration::getUserId, (Object)userId)).eq(ActivityRegistration::getStatus, (Object)2)).eq(ActivityRegistration::getFreeActivityTypeId, (Object)typeId));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            ActivityRegistration freeReg = (ActivityRegistration)list.get(0);
            freeReg.setFreeActivityTypeId(null);
            ((ActivityRegistrationMapper)this.baseMapper).updateById(freeReg);
            return true;
        }
        return false;
    }

    private boolean hasValidDiscount(Activity activity, LocalDateTime now) {
        int type = activity.getDiscountLimitType();
        if (type == 1) {
            if (activity.getDiscountStartTime() != null && activity.getDiscountEndTime() != null && !now.isBefore(activity.getDiscountStartTime()) && !now.isAfter(activity.getDiscountEndTime())) {
                return this.activityMapper.incrementDiscountRegisterCount(activity.getId()) == 1;
            }
        } else if (type == 2) {
            return this.activityMapper.lockDiscountRegisterCount(activity.getId()) == 1;
        }
        return false;
    }

    private boolean hasDiscount(Activity activity) {
        return activity.getDiscountPrice() != null && activity.getDiscountLimitType() != null && activity.getDiscountLimitType() != 0;
    }

    private void validateActivity(Activity activity) {
        if (activity == null) {
            throw new IllegalStateException("\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        LocalDateTime now = LocalDateTime.now();
        if (activity.getRegisterStartTime().isAfter(now)) {
            throw new IllegalStateException("\u6d3b\u52a8\u62a5\u540d\u8fd8\u672a\u5f00\u59cb");
        }
        if (activity.getRegisterEndTime().isBefore(now)) {
            throw new IllegalStateException("\u6d3b\u52a8\u62a5\u540d\u5df2\u7ed3\u675f");
        }
        if (activity.getActivityEndTime().isBefore(now)) {
            throw new IllegalStateException("\u6d3b\u52a8\u5df2\u7ed3\u675f");
        }
    }

    private boolean tryRegister(Long activityId, UserBasicInfo userBasicInfo) {
        boolean result;
        boolean bl = userBasicInfo.getGender() == 1 ? this.activityMapper.tryUpdateMaleCount(activityId) == 1 : (result = this.activityMapper.tryUpdateFemaleCount(activityId) == 1);
        if (result) {
            log.info("\u62a5\u540d\u6210\u529f\uff0c\u6d3b\u52a8ID\uff1a{}\uff0c\u7528\u6237ID\uff1a{}, \u6027\u522b\uff1a{}", new Object[]{activityId, userBasicInfo.getUserId(), userBasicInfo.getGender()});
        }
        return result;
    }

    private ActivityRegistration getActivityRegistration(Long activityId, Long userId, Integer status) {
        return (ActivityRegistration)((ActivityRegistrationMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ActivityRegistration::getActivityId, (Object)activityId)).eq(ActivityRegistration::getUserId, (Object)userId)).eq(ActivityRegistration::getStatus, (Object)status));
    }

    private ActivityRegistration getWaitPayActivityRegistration(Long activityId, Long userId) {
        return (ActivityRegistration)((ActivityRegistrationMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ActivityRegistration::getActivityId, (Object)activityId)).eq(ActivityRegistration::getUserId, (Object)userId)).eq(ActivityRegistration::getStatus, (Object)0)).orderByDesc(ActivityRegistration::getId)).last("LIMIT 1"));
    }

    private Integer insertRegistration(Long activityId, UserBasicInfo user, int status, boolean discount, String orderNo) {
        ActivityRegistration registration = new ActivityRegistration();
        registration.setActivityId(activityId);
        registration.setUserId(user.getUserId());
        registration.setGender(user.getGender());
        registration.setStatus(status);
        registration.setDiscountApplied(discount ? 1 : 0);
        registration.setRegistrationTime(LocalDateTime.now());
        registration.setOrderNo(orderNo);
        return ((ActivityRegistrationMapper)this.baseMapper).insert(registration);
    }

    private String createOrder(ActivityRegisterDto dto, Long userId, Activity activity, BigDecimal price) {
        String orderNum = this.idGenerator.next();
        UserOrder order = new UserOrder().setOrderNum(orderNum).setUserId(userId).setMeetTicketProductId(0L).setChannel(dto.getChannel()).setProductType(4).setProductName(activity.getName()).setProductDesc(activity.getIntro()).setTotalPrice(price).setPaymentAmount(BigDecimal.ZERO).setExtJson(String.valueOf(activity.getId())).setStatus(0);
        if (!this.userOrderService.save(order)) {
            throw new IllegalStateException("\u62a5\u540d\u5931\u8d25");
        }
        return orderNum;
    }

    @Override
    public BigDecimal calculateActivityPrice(Activity activity, Long userId) {
        List registrations;
        boolean free = this.isFree(activity, userId);
        if (free) {
            return BigDecimal.ZERO;
        }
        if (Objects.nonNull(userId) && CollectionUtils.isNotEmpty((Collection)(registrations = ((ActivityRegistrationMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ActivityRegistration::getUserId, (Object)userId)).eq(ActivityRegistration::getStatus, (Object)2)).eq(ActivityRegistration::getFreeActivityTypeId, (Object)activity.getActivityTypeId()))))) {
            return BigDecimal.ZERO;
        }
        if (Objects.nonNull(activity.getDiscountPrice()) && Objects.nonNull(activity.getDiscountLimitType()) && activity.isDiscountApplied()) {
            return activity.getDiscountPrice();
        }
        return activity.getRegisterPrice();
    }

    @Override
    public ActivityRegistration getOneByOrderNo(String orderNo) {
        return (ActivityRegistration)((ActivityRegistrationMapper)this.baseMapper).selectOne((Wrapper)new LambdaQueryWrapper().eq(ActivityRegistration::getOrderNo, (Object)orderNo));
    }

    @Override
    public Map<Long, List<ActivityUserVo>> getRegiactUserMap(List<Long> activityIdsList) {
        List<ActivityUserVo> result = ((ActivityRegistrationMapper)this.baseMapper).regiactivityUserList(activityIdsList);
        return result.stream().collect(Collectors.groupingBy(ActivityUserVo::getActivityId));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void userCancel(Long userId) {
        List registrations = ((ActivityRegistrationMapper)this.baseMapper).selectList((Wrapper)new LambdaQueryWrapper().eq(ActivityRegistration::getUserId, (Object)userId));
        if (CollectionUtils.isEmpty((Collection)registrations)) {
            return;
        }
        Integer gender = ((ActivityRegistration)CollUtil.getFirst((Iterable)registrations)).getGender();
        for (ActivityRegistration registration : registrations) {
            Activity activity = (Activity)this.activityMapper.selectById(registration.getActivityId());
            if (Objects.isNull(activity) || !activity.getActivityStartTime().isAfter(LocalDateTime.now())) continue;
            if (registration.getStatus().equals(2) || registration.getStatus().equals(0)) {
                boolean isMale;
                boolean bl = isMale = gender == 1;
                if (isMale) {
                    this.activityMapper.releaseMaleRegisterCount(activity.getId());
                } else {
                    this.activityMapper.releaseFemaleRegisterCount(activity.getId());
                }
                if (Objects.equals(1, registration.getDiscountApplied())) {
                    this.activityMapper.releaseDiscountRegisterCount(activity.getId());
                }
                if (registration.getStatus().equals(0) && StringUtils.isNotBlank((CharSequence)registration.getOrderNo())) {
                    this.userOrderService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UserOrder::getOrderNum, (Object)registration.getOrderNo())).eq(UserOrder::getUserId, (Object)userId)).set(UserOrder::getStatus, (Object)4));
                }
            }
            registration.setDeleted(1);
            ((ActivityRegistrationMapper)this.baseMapper).updateById(registration);
        }
    }

    @Override
    public ActivityPayConfigVo getPayConfig() {
        String payConfig = this.pair.get("activity_pay_config").of();
        if (StringUtils.isBlank((CharSequence)payConfig)) {
            return null;
        }
        return (ActivityPayConfigVo)JsonHelper.convert((String)payConfig, ActivityPayConfigVo.class);
    }

    @Override
    public Map<Long, ActivityRegistrationData> getActivityRegistrationDataMap(List<Long> activityIdsList) {
        if (CollectionUtils.isEmpty(activityIdsList)) {
            return Collections.emptyMap();
        }
        return this.getActivityRegistrationDataMap(this.getRegiactUserMap(activityIdsList));
    }

    @Override
    public Map<Long, ActivityRegistrationData> getActivityRegistrationDataMap(Map<Long, List<ActivityUserVo>> activityUserMap) {
        return activityUserMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            List userList = (List)entry.getValue();
            long maleCount = userList.stream().filter(user -> user.getGender() != null && user.getGender() == 1).count();
            long femaleCount = userList.stream().filter(user -> user.getGender() != null && user.getGender() == 0).count();
            ActivityRegistrationData data = new ActivityRegistrationData();
            data.setRegisteredCount(userList.size());
            data.setMaleRegisteredCount((int)maleCount);
            data.setFemaleRegisteredCount((int)femaleCount);
            return data;
        }));
    }

    private String getAppleProductId(BigDecimal price) {
        ActivityPayConfigVo activityPayConfig = this.getPayConfig();
        if (Objects.isNull(activityPayConfig) || !activityPayConfig.getIosPayTypes().contains(ActivityPayConfigVo.PayType.APPLE.getCode())) {
            return null;
        }
        if (price.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        if (MapUtils.isEmpty(activityPayConfig.getAppleProductIdMap())) {
            return null;
        }
        String appleProductId = activityPayConfig.getAppleProductIdMap().get(price);
        if (StringUtils.isBlank((CharSequence)appleProductId)) {
            log.error("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u82f9\u679c\u5546\u54c1ID,price:{}", (Object)price);
            return null;
        }
        return appleProductId;
    }
}

